/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CmdFilterAdd;
import com.starbase.starteam.CmdFilterDelete;
import com.starbase.starteam.CmdFilterModify;
import com.starbase.starteam.ColumnInfo;
import com.starbase.starteam.Filter_Cache;
import com.starbase.starteam.Filter_Data;
import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.ISecurable;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.ItemListManager;
import com.starbase.starteam.NamedCacheRef;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Type;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Filter
extends NamedCacheRef
implements Cloneable,
ISecurable {
    public static final int CONTEXT_SERVER = 1;
    public static final int CONTEXT_LOCAL = 2;
    public static final int CONTEXT_LOCAL_AND_SERVER = 3;
    private Type m_type = null;
    private boolean m_deleted = false;
    private boolean m_bDirty = false;
    private Filter_Data m_newData = null;
    private Hashtable m_ilms = new Hashtable();

    private Filter_Data getData() {
        return this.m_newData == null ? (Filter_Data)this.getCachedObject() : this.m_newData;
    }

    protected void clearNewData() {
        if (this.m_newData != null) {
            this.m_newData = null;
            this.m_bDirty = false;
        }
    }

    private Filter_Cache getCache() {
        if (this.m_type == null) {
            Assert.internalError("Filter.getCache(), type=null");
        }
        return this.m_type.getFilterCache();
    }

    private Filter_Data getNewData() {
        if (this.m_newData == null) {
            this.m_newData = (Filter_Data)this.getData().copy();
        }
        return this.m_newData;
    }

    protected String getRefName() {
        return this.getName();
    }

    public Filter copy() {
        Filter filter = new Filter(this.m_type, (Filter_Data)this.getCachedObject());
        filter.m_newData = this.m_newData != null ? (Filter_Data)this.m_newData.copy() : null;
        filter.m_deleted = this.m_deleted;
        filter.m_bDirty = this.m_bDirty;
        return filter;
    }

    public boolean isEqualTo(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (filter.m_type.getClassID() == this.m_type.getClassID() && filter.isDeleted() == this.isDeleted() && filter.isDirty() == this.isDirty()) {
            return this.getData().isEqualTo(filter.getData());
        }
        return false;
    }

    public boolean isDirty() {
        return this.m_bDirty;
    }

    public boolean isPublic() {
        return this.getData().isPublic();
    }

    public Type getType() {
        return this.m_type;
    }

    public Property[] getProperties() {
        Vector vector = new Vector();
        this.getGroupSortInfoProperties(vector);
        this.getQueryInfoProperties(vector);
        this.getColumnInfoProperties(vector);
        Object[] objectArray = new Property[vector.size()];
        vector.copyInto(objectArray);
        return Property.resolveAllDependencies((Property[])objectArray);
    }

    public int getID() {
        return this.getData().getID();
    }

    public int getUserID() {
        return this.getData().getUserID();
    }

    public void makePublic() {
        if (!this.isPublic()) {
            this.getNewData().makePublic();
            this.m_bDirty = true;
        }
    }

    public String getName() {
        return this.getData().getName();
    }

    public void setName(String string) {
        if (string == null) {
            Assert.nullArgument("String");
        }
        if (!this.getName().equals(string)) {
            this.getNewData().setName(string);
            this.m_bDirty = true;
        }
    }

    public int getQueryID() {
        return this.getData().getQueryID();
    }

    public void setQueryID(int n) {
        if (this.getQueryID() != n) {
            this.getNewData().setQueryID(n);
            this.setIlmsDirty(2);
            this.m_bDirty = true;
        }
    }

    public int getContext() {
        return this.getData().getContext();
    }

    public void setContext(int n) {
        this.verifyContext(n);
        if (this.getContext() != n) {
            this.getNewData().setContext(n);
            this.setIlmsDirty(1);
            this.m_bDirty = true;
        }
    }

    public GroupSortInfo[] getGroupSortInfo() {
        this.getNewData();
        return this.getData().getGroupSortInfo();
    }

    public void setGroupSortInfo(GroupSortInfo[] groupSortInfoArray) {
        this.verifyGroupSortInfo(groupSortInfoArray);
        this.getNewData().setGroupSortInfo(groupSortInfoArray);
        this.setIlmsDirty(0);
        this.m_bDirty = true;
    }

    public int getGroupingDepth() {
        int n = 0;
        GroupSortInfo[] groupSortInfoArray = this.getGroupSortInfo();
        int n2 = 0;
        while (n2 < groupSortInfoArray.length) {
            if (!groupSortInfoArray[n2].isGroup()) break;
            ++n;
            ++n2;
        }
        return n;
    }

    public ColumnInfo[] getColumnInfo() {
        this.getNewData();
        return this.getData().getColumnInfo();
    }

    public void setColumnInfo(ColumnInfo[] columnInfoArray) {
        if (columnInfoArray == null) {
            Assert.nullArgument("ColumnInfo[]");
        }
        this.getNewData().setColumnInfo(columnInfoArray);
        this.setIlmsDirty(3);
        this.m_bDirty = true;
    }

    public void appendColumn(String string, int n) {
        Property property = this.m_type.propertyForName(string);
        ColumnInfo columnInfo = new ColumnInfo(property.getID(), n);
        ColumnInfo[] columnInfoArray = this.getColumnInfo();
        int n2 = columnInfoArray.length;
        ColumnInfo[] columnInfoArray2 = new ColumnInfo[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            columnInfoArray2[n3] = columnInfoArray[n3];
            ++n3;
        }
        columnInfoArray2[n2] = columnInfo;
        this.setColumnInfo(columnInfoArray2);
        this.setIlmsDirty(3);
        this.m_bDirty = true;
    }

    public void clearColumns() {
        this.getNewData().clearColumns();
        this.setIlmsDirty(3);
        this.m_bDirty = true;
    }

    public void clearGroupSortInfo() {
        this.getNewData().clearGroupSortInfo();
        this.setIlmsDirty(0);
        this.m_bDirty = true;
    }

    public void appendGroupSortInfo(boolean bl, String string, boolean bl2) {
        Property property = this.m_type.propertyForName(string);
        GroupSortInfo groupSortInfo = new GroupSortInfo(bl, property.getID(), bl2);
        GroupSortInfo[] groupSortInfoArray = this.getGroupSortInfo();
        int n = groupSortInfoArray.length;
        GroupSortInfo[] groupSortInfoArray2 = new GroupSortInfo[n + 1];
        int n2 = 0;
        while (n2 < n) {
            groupSortInfoArray2[n2] = groupSortInfoArray[n2];
            ++n2;
        }
        groupSortInfoArray2[n] = groupSortInfo;
        this.verifyGroupSortInfo(groupSortInfoArray2);
        this.setGroupSortInfo(groupSortInfoArray2);
        this.setIlmsDirty(0);
        this.m_bDirty = true;
    }

    public boolean isNew() {
        return this.getData().isNew();
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public void update() {
        if (this.isDeleted()) {
            throw new IllegalStateException(Res.getString(ResIDs.FILTER_HAS_BEEN_DELETED));
        }
        if (this.isNew()) {
            this.getCache().setIDsModified();
            CmdFilterAdd cmdFilterAdd = new CmdFilterAdd(this.m_type.getServer(), this.m_type.getClassID(), this.getData());
            cmdFilterAdd.execute();
        } else {
            this.getCache().setObjectDirty(this.getID());
            CmdFilterModify cmdFilterModify = new CmdFilterModify(this.m_type.getServer(), this.m_type.getClassID(), this.getData());
            cmdFilterModify.execute();
        }
        this.m_bDirty = false;
    }

    public void delete() {
        if (!this.isDeleted()) {
            this.getCache().setObjectDirty(this.getID());
            this.getCache().setIDsModified();
            CmdFilterDelete cmdFilterDelete = new CmdFilterDelete(this.m_type.getServer(), this.m_type.getClassID(), this.getData());
            cmdFilterDelete.execute();
            this.markDeleted();
        }
    }

    public AclEntry[] getACL() {
        return SecurityAccess.getComponentObjectACL(this.m_type, this.m_type.getFilterClassID(), this.getID());
    }

    public void setACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setComponentObjectACL(this.m_type, this.m_type.getFilterClassID(), this.getID(), true, aclEntryArray);
    }

    public boolean hasPermission(int n) {
        return SecurityAccess.componentObjectAccessTest(this.m_type, this.m_type.getFilterClassID(), this.getID(), n);
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("ItemType: " + this.m_type.getName() + string);
        stringBuffer.append("Deleted: " + (this.m_deleted ? "true" : "false") + string);
        stringBuffer.append("CachedData: " + this.getData().toDebugString() + string);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    void markDeleted() {
        this.m_deleted = true;
    }

    void setID(int n) {
        this.getNewData().setID(n);
    }

    private void verifyGroupSortInfo(GroupSortInfo[] groupSortInfoArray) {
        if (groupSortInfoArray == null) {
            Assert.nullArgument("GroupSortInfo[]");
        }
        if (groupSortInfoArray.length > 4) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ONLY_FOUR_LEVELS_GROUPING_SORTING_SUPPORTED));
        }
        boolean bl = false;
        int n = 0;
        while (n < groupSortInfoArray.length) {
            if (groupSortInfoArray[n].isSort()) {
                bl = true;
            } else if (bl) {
                throw new IllegalArgumentException(Res.getString(ResIDs.A_GROUP_CANNOT_FOLLOW_A_SORT));
            }
            ++n;
        }
    }

    private void getQueryInfoProperties(Vector vector) {
        int n = this.getQueryID();
        if (this.m_type.hasQueryForID(n)) {
            int[] nArray = this.m_type.getQueryForID(n).getPropertyIDs();
            int n2 = 0;
            while (n2 < nArray.length) {
                Property property = this.m_type.propertyForPID(nArray[n2]);
                if (!vector.contains(property)) {
                    vector.addElement(property);
                }
                ++n2;
            }
        }
    }

    private void getGroupSortInfoProperties(Vector vector) {
        GroupSortInfo[] groupSortInfoArray = this.getGroupSortInfo();
        int n = 0;
        while (n < groupSortInfoArray.length) {
            Property property = this.m_type.propertyForPID(groupSortInfoArray[n].getPropertyID());
            if (!vector.contains(property)) {
                vector.addElement(property);
            }
            ++n;
        }
    }

    private void getColumnInfoProperties(Vector vector) {
        ColumnInfo[] columnInfoArray = this.getColumnInfo();
        int n = 0;
        while (n < columnInfoArray.length) {
            Property property = this.m_type.propertyForPID(columnInfoArray[n].getPropertyID());
            if (!vector.contains(property)) {
                vector.addElement(property);
            }
            ++n;
        }
    }

    void registerIlm(ItemListManager itemListManager) {
        this.m_ilms.put(itemListManager, itemListManager);
    }

    private void verifyContext(int n) {
        if (n != 3 && n != 2 && n != 1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_FILTER_DATA_CONTEXT_FMT, new Object[]{new Integer(n)}));
        }
    }

    private void setIlmsDirty(int n) {
        Enumeration enumeration = this.m_ilms.elements();
        while (enumeration.hasMoreElements()) {
            ((ItemListManager)enumeration.nextElement()).setDirtyFlag(n, true);
        }
    }

    public ISecurableContainer getParentContainer() {
        return this.getType();
    }

    public Filter(Type type, String string, int n, boolean bl) {
        super(new Filter_Data(string, n, bl ? -1 : type.getServer().getLoggedInUserID()));
        this.verifyContext(n);
        if (string == null) {
            Assert.nullArgument("String");
        }
        this.m_type = type;
    }

    Filter(Type type, Filter_Data filter_Data) {
        super(filter_Data);
        this.m_type = type;
    }
}

