/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SyncDB;
import com.starbase.util.Assert;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileBasedStatusManager {
    private Hashtable m_serverIDs = new Hashtable(100);
    private Hashtable dbs = new Hashtable();
    private Link syncList = null;
    private int currentRecords = 0;
    private File m_centralDir = null;
    private int maxRecords = 50;

    private void clearAll() {
        this.syncList = null;
        this.dbs = new Hashtable();
        this.currentRecords = 0;
    }

    private void makeRoom() {
        if (this.currentRecords > this.maxRecords) {
            this.debug("making room, was: " + this.currentRecords);
            while (this.currentRecords > this.maxRecords) {
                Link link = this.getLastLink();
                if (link == null) break;
                this.dropLink(link);
            }
            this.debug("done making room, now: " + this.currentRecords);
        }
    }

    void notifyDBChange(int n, int n2) {
        this.currentRecords += n2 - n;
    }

    private void printLRU() {
        if (this.syncList == null) {
            System.out.println("NO LRU LIST");
        } else {
            System.out.println("LRU list:");
            Link link = this.syncList;
            Link link2 = this.syncList.next;
            System.out.println("    " + link.data.getPath() + " size=" + link.data.size());
            while (link2 != link) {
                System.out.println("    " + link2.data.getPath() + " size=" + link2.data.size());
                link2 = link2.next;
            }
            System.out.println("end LRU list.");
        }
    }

    private void moveToFront(Link link) {
        if (this.syncList == null) {
            this.syncList = link;
            link.next = link;
            link.prev = link;
        } else if (link != this.syncList) {
            Link link2 = link.prev;
            Link link3 = link.next;
            if (link2 != null) {
                link2.next = link3;
                link3.prev = link2;
            }
            Link link4 = this.syncList;
            Link link5 = this.syncList.prev;
            this.syncList = link;
            link.next = link4;
            link4.prev = link;
            link.prev = link5;
            link5.next = link;
        }
    }

    private void dropLink(Link link) {
        if (this.syncList == link) {
            if (link.next == link) {
                this.syncList = null;
                this.debug("dropping: " + link.data.getPath());
                this.dbs.remove(link.data.getPath());
                this.notifyDBChange(link.data.size(), 0);
                link.data = null;
                link.next = null;
                link.prev = null;
            }
        } else {
            this.debug("dropping: " + link.data.getPath());
            this.dbs.remove(link.data.getPath());
            this.notifyDBChange(link.data.size(), 0);
            Link link2 = link.prev;
            Link link3 = link.next;
            link.data = null;
            link.next = null;
            link.prev = null;
            link2.next = link3;
            link3.prev = link2;
        }
    }

    private Link getLastLink() {
        if (this.syncList != null) {
            return this.syncList.prev;
        }
        return null;
    }

    public boolean isCentral() {
        return !this.isPerFolder();
    }

    public boolean isPerFolder() {
        return this.m_centralDir == null;
    }

    void setLocation(File file) throws IOException {
        String string;
        String string2;
        if (this.m_centralDir == null) {
            throw new RuntimeException(Res.getString(ResIDs.CAN_NOT_CHANGE_STATUS_MANAGER_LOCATION));
        }
        if (file == null) {
            Assert.nullArgument("File");
        }
        if (!(string2 = file.getCanonicalPath()).equals(string = this.m_centralDir.getCanonicalPath())) {
            this.m_centralDir = file;
            this.clearAll();
        }
    }

    void refresh(File file, boolean bl) throws IOException {
        File file2 = null;
        try {
            file2 = new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return;
        }
        String string = file2.getParent();
        SyncDB syncDB = this.getDB(string, false, bl);
        if (syncDB != null) {
            int n = syncDB.size();
            syncDB.refresh();
            int n2 = syncDB.size();
            this.notifyDBChange(n, n2);
        }
    }

    public FileSyncInfo getFileSyncInfo(File file, boolean bl) throws IOException {
        File file2 = null;
        try {
            file2 = new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return null;
        }
        String string = file2.getParent();
        String string2 = file2.getName();
        SyncDB syncDB = this.getDB(string, false, bl);
        if (syncDB != null) {
            int n = syncDB.size();
            FileSyncInfo fileSyncInfo = syncDB.getSyncInfo(string2);
            int n2 = syncDB.size();
            this.notifyDBChange(n, n2);
            return fileSyncInfo;
        }
        return null;
    }

    public void setFileSyncInfo(File file, FileSyncInfo fileSyncInfo, boolean bl) throws IOException {
        File file2 = new File(file.getCanonicalPath());
        String string = file2.getParent();
        String string2 = file2.getName();
        SyncDB syncDB = this.getDB(string, true, bl);
        int n = syncDB.size();
        syncDB.setSyncInfo(string2, fileSyncInfo);
        int n2 = syncDB.size();
        this.notifyDBChange(n, n2);
    }

    public void deleteFileSyncInfo(File file, boolean bl) throws IOException {
        File file2 = null;
        try {
            file2 = new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return;
        }
        String string = file2.getParent();
        String string2 = file2.getName();
        SyncDB syncDB = this.getDB(string, false, bl);
        if (syncDB != null) {
            int n = syncDB.size();
            syncDB.removeSyncInfo(string2);
            int n2 = syncDB.size();
            this.notifyDBChange(n, n2);
        }
    }

    private SyncDB getDB(String string, boolean bl, boolean bl2) throws IOException {
        Hashtable hashtable = this.dbs;
        synchronized (hashtable) {
            Object object;
            if (!bl) {
                try {
                    try {
                        object = null;
                        object = this.m_centralDir == null ? new File(string) : this.m_centralDir;
                        if (!((File)object).exists() || !((File)object).isDirectory()) {
                            SyncDB syncDB = null;
                            Object var5_12 = null;
                            return syncDB;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        SyncDB syncDB = null;
                        Object var5_13 = null;
                        return syncDB;
                    }
                }
                catch (Exception exception) {
                    SyncDB syncDB = null;
                    Object var5_14 = null;
                    return syncDB;
                }
            }
            if ((object = (Link)this.dbs.get(string)) == null) {
                SyncDB syncDB = null;
                syncDB = this.m_centralDir == null ? new SyncDB(string, this) : new SyncDB(string, this, this.m_centralDir, bl2);
                FileBasedStatusManager fileBasedStatusManager = this;
                if (fileBasedStatusManager == null) {
                    throw null;
                }
                object = fileBasedStatusManager.new Link();
                ((Link)object).data = syncDB;
                this.dbs.put(string, object);
                this.notifyDBChange(0, syncDB.size());
                this.makeRoom();
            }
            this.moveToFront((Link)object);
            SyncDB syncDB = ((Link)object).data;
            Object var5_15 = null;
            return syncDB;
        }
    }

    String getRepositoryID(String string) {
        String string2 = (String)this.m_serverIDs.get(string);
        if (string2 == null) {
            string2 = string;
            this.m_serverIDs.put(string, string);
        }
        return string2;
    }

    private void dumpSync(File file, boolean bl) throws IOException {
        Object object;
        String string = null;
        if (file.isDirectory()) {
            string = file.getCanonicalPath();
        } else {
            object = new File(file.getCanonicalPath());
            string = ((File)object).getParent();
        }
        object = this.getDB(string, false, bl);
        if (object != null) {
            ((SyncDB)object).debugDump();
        }
    }

    private final void debug(Object object) {
    }

    private void debugDump() {
        System.out.println("Max: " + this.maxRecords);
        System.out.println("Current: " + this.currentRecords);
        this.printLRU();
        System.out.println("Repository IDs:");
        Enumeration enumeration = this.m_serverIDs.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("    " + enumeration.nextElement());
        }
    }

    private FileBasedStatusManager() {
    }

    FileBasedStatusManager(int n, File file) {
        this.maxRecords = n;
        this.m_centralDir = file;
    }

    FileBasedStatusManager(int n) {
        this.maxRecords = n;
    }

    private class Link {
        public SyncDB data = null;
        public Link next = null;
        public Link prev = null;
    }
}

