/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.borland.starteam.util.Encoding;
import com.starbase.starteam.AddResult;
import com.starbase.starteam.CheckInResult;
import com.starbase.starteam.CheckOutResult;
import com.starbase.starteam.CheckOutStream;
import com.starbase.starteam.ClientContext;
import com.starbase.starteam.CmdConvertArchive;
import com.starbase.starteam.CmdFileAdd;
import com.starbase.starteam.CmdFileCheckin;
import com.starbase.starteam.CmdFileUpdateProperty;
import com.starbase.starteam.CmdResyncFile;
import com.starbase.starteam.CmdUpdateStatus;
import com.starbase.starteam.DestIDCache;
import com.starbase.starteam.FileDigest;
import com.starbase.starteam.FileStream;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.File_CmdArchiveConversion;
import com.starbase.starteam.Folder;
import com.starbase.starteam.ForeignPasswordException;
import com.starbase.starteam.IdentityReader;
import com.starbase.starteam.Item;
import com.starbase.starteam.Keyword;
import com.starbase.starteam.KeywordReader;
import com.starbase.starteam.Keywords;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Project;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyEnums;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.RevisionIdentifier;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.Status;
import com.starbase.starteam.StatusDataImpl;
import com.starbase.starteam.SyncUpdateType;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource_Marshaler;
import com.starbase.starteam.View;
import com.starbase.starteam.vts.comm.CommandException;
import com.starbase.starteam.vts.comm.Connection;
import com.starbase.starteam.vts.comm.ConnectionException;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.starteam.vts.pickle.FileRevisionID;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.Assert;
import com.starbase.util.FileUtils;
import com.starbase.util.LineReader;
import com.starbase.util.MD5;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import com.starbase.util.StreamUtils;
import com.starbase.util.TextInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class File
extends Item {
    private static final String EMPTY_STRING = "";
    private static int NATIVEII_CONVERT_ONLY = 1;
    private static int NATIVEII_CONVERT_AND_DELETE_OLD_ARCHIVES = 2;

    public static String getDefaultEncoding() {
        return Encoding.getDefaultStarTeamEncoding().getName();
    }

    public static void setDefaultEncoding(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        Encoding encoding = Encoding.forName(string);
        if (string != null) {
            Encoding.setDefaultStarTeamEncoding(encoding);
        } else {
            ((Hashtable)System.getProperties()).put("starteam.file.encoding", string);
        }
    }

    int getRoutingClassID() {
        return this.getServer().getClassID(this.getTypeNames().FILE);
    }

    int getRoutingComponentID() {
        return this.getServer().getComponentID(ServerComponentInfo.FILE);
    }

    void setPVCSProjectID(int n) {
    }

    void setPVCSRevision(String string) {
    }

    public String getFullName() {
        this.verifyNotDisembodied();
        return this.getParentFolder().getFilePath(this.getName());
    }

    public String getName() {
        return (String)this.getCachedValue(this.getPropertyNames().FILE_NAME);
    }

    public void setName(String string) {
        this.put(this.getPropertyNames().FILE_NAME, string);
    }

    public String getDescription() {
        return (String)this.getCachedValue(this.getPropertyNames().FILE_DESCRIPTION);
    }

    public void setDescription(String string) {
        this.put(this.getPropertyNames().FILE_DESCRIPTION, string);
    }

    public int getVaultVersion() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_VAULT_BRANCH_VERSION);
    }

    public int getContentVersion() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_CONTENT_REVISION);
    }

    public OLEDate getContentModificationTime() {
        return (OLEDate)this.getCachedValue(this.getPropertyNames().FILE_FILE_TIME_AT_CHECKIN);
    }

    public void setContentModificationTime(OLEDate oLEDate) {
        this.put(this.getPropertyNames().FILE_FILE_TIME_AT_CHECKIN, oLEDate);
    }

    public int getSize() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_SIZE);
    }

    public int getArchiveType() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_ARCHIVE_TYPE);
    }

    public int[] getPossibleArchiveType() {
        return this.getPossibleValues(this.getPropertyNames().FILE_ARCHIVE_TYPE);
    }

    public String getArchiveTypeDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().FILE_ARCHIVE_TYPE, n);
    }

    public int getArchiveFormat() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_ARCHIVE_FORMAT);
    }

    public String getArchiveName() {
        return (String)this.getCachedValue(this.getPropertyNames().FILE_ARCHIVE_NAME);
    }

    public int[] getPossibleArchiveFormat() {
        return this.getPossibleValues(this.getPropertyNames().FILE_ARCHIVE_FORMAT);
    }

    public String getArchiveFormatDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().FILE_ARCHIVE_FORMAT, n);
    }

    public int getCharset() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_ENCODING);
    }

    public int[] getPossibleCharset() {
        return this.getPossibleValues(this.getPropertyNames().FILE_ENCODING);
    }

    public String getCharsetDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().FILE_ENCODING, n);
    }

    public byte[] getMD5() {
        return (byte[])this.getCachedValue(this.getPropertyNames().FILE_MD5_CHECKSUM);
    }

    public int getStorageFormat() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_STORAGE_TYPE);
    }

    public void setStorageFormat(int n) {
        this.put(this.getPropertyNames().FILE_STORAGE_TYPE, new Integer(n));
    }

    public int[] getPossibleStorageFormat() {
        return this.getPossibleValues(this.getPropertyNames().FILE_STORAGE_TYPE);
    }

    public String getStorageFormatDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().FILE_STORAGE_TYPE, n);
    }

    public int getCompression() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FILE_COMPRESSION_LEVEL);
    }

    public void setCompression(int n) {
        this.put(this.getPropertyNames().FILE_COMPRESSION_LEVEL, new Integer(n));
    }

    public int[] getPossibleCompression() {
        return this.getPossibleValues(this.getPropertyNames().FILE_COMPRESSION_LEVEL);
    }

    public String getCompressionDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().FILE_COMPRESSION_LEVEL, n);
    }

    public File findCommonAnscestor(File file) {
        return (File)this.getCommonAncestor(file);
    }

    public File findMergeVersion() {
        this.verifyNotDisembodied();
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return null;
        }
        int n = (Integer)this.getCachedValue(this.getPropertyNames().ROOT_OBJECT_ID);
        if (!this.getServer().getRepositoryID().canonicalFormat().equals(fileSyncInfo.getRevisionIdentifier().getRepositoryID())) {
            return null;
        }
        if (n != fileSyncInfo.getRevisionIdentifier().getRootObjectID()) {
            return null;
        }
        String string = Status.findCommonAncestor(this.getDotNotation(), fileSyncInfo.getRevisionIdentifier().getDotNotation());
        File file = null;
        Item[] itemArray = this.getHistory();
        int n2 = 0;
        while (n2 < itemArray.length) {
            File file2 = (File)itemArray[n2];
            if (file2.getDotNotation().equals(string)) {
                file = file2;
                break;
            }
            ++n2;
        }
        return file;
    }

    public boolean isBinary() {
        return this.getCharset() == 0;
    }

    public void update() {
        if (this.isNew()) {
            this.verifyNotDisembodied();
            String string = this.getParentFolder().getFilePath(this.getName());
            try {
                this.add(new java.io.File(string), this.getName(), this.getDescription(), this.getComment(), 3, false, true);
            }
            catch (IOException iOException) {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.UNABLE_TO_ADD_FILE_FMT, new Object[]{string}), iOException);
            }
        } else {
            this.renameCore();
        }
        if (!SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            this.markClean();
            this.retrieveReplicatedData();
        }
    }

    public void rename(String string) {
        try {
            String string2 = this.getName();
            if (string2.equals(string)) {
                this.update();
            } else if (this.isDisembodied()) {
                this.setName(string);
                this.update();
            } else {
                java.io.File file = new java.io.File(this.getFullName());
                boolean bl = file.exists();
                String string3 = file.getCanonicalPath();
                FileSyncInfo fileSyncInfo = this.getStatusData();
                this.setName(string);
                this.update();
                java.io.File file2 = new java.io.File(this.getFullName());
                boolean bl2 = file2.exists();
                String string4 = file2.getCanonicalPath();
                if (bl) {
                    boolean bl3 = true;
                    if (bl2) {
                        bl3 = string3.equals(string4);
                    }
                    if (bl3 && file.renameTo(file2) && fileSyncInfo != null) {
                        StatusDataImpl statusDataImpl = new StatusDataImpl(this.getServer().getRepositoryID());
                        statusDataImpl.setFromFileSyncInfo(fileSyncInfo);
                        this.updateStatusCore(statusDataImpl, file2.getPath(), statusDataImpl.getFileSize(), statusDataImpl.getFileMD5(), statusDataImpl.getFileTime());
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new SDKRuntimeException(iOException);
        }
    }

    public void convertArchive(boolean bl, int n) {
        boolean bl2;
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.CAN_NOT_CONVERT_ARCHIVE));
        }
        PropertyEnums propertyEnums = this.getServer().getPropertyEnums();
        boolean bl3 = bl2 = n == propertyEnums.FILE_COMPRESSION_LEVEL_NONE || n == propertyEnums.FILE_COMPRESSION_LEVEL_MAXIMIZE_SPEED || n == propertyEnums.FILE_COMPRESSION_LEVEL_DEFAULT || n == propertyEnums.FILE_COMPRESSION_LEVEL_MAXIMIZE_COMPRESSION;
        if (!bl2) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_COMPRESSION_LEVEL_FMT, new Object[]{new Integer(n)}));
        }
        CmdConvertArchive cmdConvertArchive = new CmdConvertArchive(this, bl, n);
        cmdConvertArchive.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getServer().getComponentID(ServerComponentInfo.FILE));
    }

    public void convertToNativeIIArchive(boolean bl) {
        if (this.getServer().getSupportedFeatures().hasNativeIIVault()) {
            File_CmdArchiveConversion file_CmdArchiveConversion = new File_CmdArchiveConversion(this.getServer(), this.getView(), this.getServer().getComponentID(ServerComponentInfo.FILE), this.getItemID(), bl ? NATIVEII_CONVERT_AND_DELETE_OLD_ARCHIVES : NATIVEII_CONVERT_ONLY);
            file_CmdArchiveConversion.execute();
        }
    }

    public void add(java.io.File file, String string, String string2, String string3, int n, boolean bl, boolean bl2) throws IOException {
        this.verifyNotDisembodied();
        this.addCore(file, string, string2 == null ? EMPTY_STRING : string2, string3 == null ? EMPTY_STRING : string3, n, bl, bl2);
        this.markClean();
    }

    public AddResult addAndReturn(java.io.File file, String string, String string2, String string3, int n, boolean bl, boolean bl2) throws IOException {
        this.verifyNotDisembodied();
        AddResult addResult = this.addCore(file, string, string2 == null ? EMPTY_STRING : string2, string3 == null ? EMPTY_STRING : string3, n, bl, bl2);
        this.markClean();
        return addResult;
    }

    public void addFromStream(InputStream inputStream, String string, String string2, String string3, int n, boolean bl) throws IOException {
        FileStream.Sender sender;
        boolean bl2;
        block4: {
            this.verifyNotDisembodied();
            Folder folder = this.getParentFolder();
            int n2 = folder.getItemID();
            String string4 = string3 == null ? EMPTY_STRING : string3;
            String string5 = string2 == null ? EMPTY_STRING : string2;
            String string6 = string;
            int n3 = -1;
            double d = 0.0;
            int n4 = -1;
            MD5 mD5 = new MD5();
            this.setName(string6);
            this.setDescription(string5);
            this.setContentModificationTime(new OLEDate(0.0));
            bl2 = this.usesKeywords();
            sender = FileStream.getSender(inputStream, false, bl2, bl);
            StStatusData stStatusData = null;
            Keywords keywords = null;
            SyncUpdateType syncUpdateType = SyncUpdateType.NOUPDATE;
            try {
                boolean bl3 = folder.getServer().getClientContext().getCaseSensitiveFileNames();
                CmdFileAdd cmdFileAdd = new CmdFileAdd(this, n2, string4, sender, n, this.getDirtyProperties(), -1, syncUpdateType, n3, bl3, d, n4, mD5, bl2, new TypedResource_Marshaler(), this.getServer().getRepositoryID());
                cmdFileAdd.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingClassID());
                stStatusData = cmdFileAdd.getStatusData();
                if (!bl2) break block4;
                keywords = new Keywords();
                keywords.setFrom(this, cmdFileAdd.getKeywordValues(), cmdFileAdd.getHistory(), this.getViews());
            }
            catch (Throwable throwable) {
                Object var23_24 = null;
                sender.close();
                throw throwable;
            }
        }
        Object var23_23 = null;
        sender.close();
        if (bl2) {
            // empty if block
        }
        if (!SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            this.markClean();
        }
    }

    private AddResult addCore(java.io.File file, String string, String string2, String string3, int n, boolean bl, boolean bl2) throws IOException {
        this.verifyNotDisembodied();
        Keyword[] keywordArray = new Keyword[]{};
        Folder folder = this.getParentFolder();
        int n2 = folder.getItemID();
        String string4 = string3 == null ? EMPTY_STRING : string3;
        String string5 = string2 == null ? EMPTY_STRING : string2;
        String string6 = string == null ? FileUtils.getName(file.getPath(), this.getServer().getClientContext().getFilePathDelimiter()) : string;
        int n3 = -1;
        if (!this.getServer().isSyncStoredLocally()) {
            n3 = DestIDCache.getID(this.getParentFolder(), file.getParent());
        }
        if (this.getServer().getSupportedFeatures().hasFileExecutablePermission()) {
            boolean bl3 = Platform.getFileExecutable(file);
            PropertyEnums propertyEnums = this.getServer().getPropertyEnums();
            this.put(this.getPropertyNames().FILE_EXECUTABLE, new Integer(bl3 ? propertyEnums.FILE_EXECUTABLE_YES : propertyEnums.FILE_EXECUTABLE_NO));
        }
        double d = Platform.getFileLastModified(file);
        int n4 = -1;
        MD5 mD5 = new MD5();
        this.setName(string6);
        this.setDescription(string5);
        this.setContentModificationTime(new OLEDate(d));
        boolean bl4 = FileUtils.isBinary(file);
        boolean bl5 = this.usesKeywords();
        if (!bl5 && bl2) {
            n4 = FileUtils.getFileLength(file);
            mD5.computeFileMD5(file);
        }
        FileStream.Sender sender = FileStream.getSender(file, bl4, bl5, bl);
        StStatusData stStatusData = null;
        Keywords keywords = null;
        SyncUpdateType syncUpdateType = bl2 && !this.getServer().isSyncStoredLocally() ? SyncUpdateType.UPDATE : SyncUpdateType.NOUPDATE;
        try {
            boolean bl6 = folder.getServer().getClientContext().getCaseSensitiveFileNames();
            CmdFileAdd cmdFileAdd = new CmdFileAdd(this, n2, string4, sender, n, this.getDirtyProperties(), -1, syncUpdateType, n3, bl6, d, n4, mD5, bl5, new TypedResource_Marshaler(), this.getServer().getRepositoryID());
            cmdFileAdd.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingClassID());
            stStatusData = cmdFileAdd.getStatusData();
            if (bl5) {
                keywords = new Keywords();
                keywords.setFrom(this, cmdFileAdd.getKeywordValues(), cmdFileAdd.getHistory(), this.getViews());
                keywordArray = keywords.getKeywords();
            }
            folder.addItem(this);
        }
        finally {
            Object var26_29 = null;
            sender.close();
        }
        if (bl5) {
            this.expandKeywords(keywords.getKeywords(), file);
        }
        if (bl2) {
            if (this.getServer().isSyncStoredLocally()) {
                StatusDataImpl statusDataImpl = new StatusDataImpl(this.getServer().getRepositoryID());
                statusDataImpl.initFromFile(this);
                statusDataImpl.setDotNotation(this.getDotNotation());
                statusDataImpl.setFileSize(file.length());
                if (bl5) {
                    mD5.computeFileMD5(file);
                }
                statusDataImpl.setFileMD5(mD5);
                statusDataImpl.setFileTime(Platform.getFileLastModified(file));
                this.getServer().cacheStatusData(this.getParentFolder(), file.getPath(), statusDataImpl);
            } else {
                this.updateStatusCore(stStatusData, file);
            }
        }
        return new AddResult(keywordArray);
    }

    public void checkin(String string, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verifyNotDisembodied();
        this.checkinCore(null, string, n, bl, bl2, bl3);
    }

    public void checkinFrom(java.io.File file, String string, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verifyNotDisembodied();
        this.checkinCore(file, string, n, bl, bl2, bl3);
    }

    public CheckInResult checkinFromAndReturn(java.io.File file, String string, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verifyNotDisembodied();
        return this.checkinCore(file, string, n, bl, bl2, bl3);
    }

    public void checkinFromStream(InputStream inputStream, String string, int n, boolean bl) throws IOException {
        String string2 = string == null ? EMPTY_STRING : string;
        boolean bl2 = false;
        boolean bl3 = this.usesKeywords();
        boolean bl4 = bl;
        if (bl2) {
            bl4 = false;
        }
        FileStream.Sender sender = FileStream.getSender(inputStream, bl2, bl3, bl4);
        this.getName();
        CmdFileCheckin cmdFileCheckin = null;
        double d = 0.0;
        int n2 = 0;
        MD5 mD5 = new MD5();
        int n3 = -1;
        boolean bl5 = this.getServer().getClientContext().getCaseSensitiveFileNames();
        this.setContentModificationTime(new OLEDate(0.0));
        SyncUpdateType syncUpdateType = SyncUpdateType.NOUPDATE;
        try {
            cmdFileCheckin = new CmdFileCheckin(this, string2, sender, n, this.getDirtyProperties(), true, -1, syncUpdateType, n3, bl5, d, n2, mD5, bl3, new TypedResource_Marshaler(), this.getServer().getRepositoryID(), new FileRevisionID(), false);
            cmdFileCheckin.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingClassID());
        }
        finally {
            Object var19_17 = null;
            sender.close();
        }
        StStatusData stStatusData = cmdFileCheckin.getStatusData();
        if (!SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            try {
                this.discard();
                if (stStatusData != null) {
                    this.initializeReplicaValue(this.getPropertyNames().ROOT_OBJECT_ID, (Object)new Integer(stStatusData.m_rootObjectID));
                    this.initializeReplicaValue(this.getPropertyNames().OBJECT_ID, (Object)new Integer(stStatusData.m_objectID));
                    this.initializeReplicaValue(this.getPropertyNames().REVISION_NUMBER, (Object)new Integer(stStatusData.m_version));
                }
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                Assert.internalError("File.checkinFromStream()", noSuchPropertyException);
            }
        }
    }

    private CheckInResult checkinCore(java.io.File file, String string, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Object object;
        this.verifyNotDisembodied();
        Keyword[] keywordArray = new Keyword[]{};
        java.io.File file2 = file;
        if (file == null) {
            file2 = new java.io.File(this.getFullName());
        }
        String string2 = string == null ? EMPTY_STRING : string;
        boolean bl4 = FileUtils.isBinary(file2);
        boolean bl5 = this.usesKeywords();
        boolean bl6 = bl2;
        if (bl4) {
            bl6 = false;
        }
        FileStream.Sender sender = FileStream.getSender(file2, bl4, bl5, bl6);
        this.getName();
        CmdFileCheckin cmdFileCheckin = null;
        Keywords keywords = null;
        double d = Platform.getFileLastModified(file2);
        int n2 = 0;
        MD5 mD5 = new MD5();
        int n3 = -1;
        Folder folder = this.getParentFolder();
        boolean bl7 = folder.getServer().getClientContext().getCaseSensitiveFileNames();
        this.setContentModificationTime(new OLEDate(d));
        if (bl3 && !this.getServer().isSyncStoredLocally()) {
            n3 = DestIDCache.getID(folder, file2.getParent());
        }
        if (!bl5 && bl3) {
            n2 = FileUtils.getFileLength(file2);
            mD5.computeFileMD5(file2);
        }
        SyncUpdateType syncUpdateType = bl3 && !this.getServer().isSyncStoredLocally() ? SyncUpdateType.UPDATE : SyncUpdateType.NOUPDATE;
        try {
            FileSyncInfo fileSyncInfo;
            object = new FileRevisionID();
            boolean bl8 = false;
            if (!bl && SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel()) && (fileSyncInfo = this.prepareSyncInfo(file2.getPath())) != null && fileSyncInfo.getRevisionIdentifier().getRepositoryID().equals(this.getServer().getRepositoryID().canonicalFormat())) {
                long l = FileUtils.getFileLength(file2);
                double d2 = Platform.getFileLastModified(file2);
                bl8 = l != fileSyncInfo.getFileDigest().getFileSize() || d2 != fileSyncInfo.getFileDigest().getFileTime();
                RevisionIdentifier revisionIdentifier = fileSyncInfo.getRevisionIdentifier();
                ((FileRevisionID)object).setRevisionInfo(revisionIdentifier.getRootObjectID(), revisionIdentifier.getObjectID(), revisionIdentifier.getRevisionNumber(), revisionIdentifier.getContentRevision(), revisionIdentifier.getDotNotation());
            }
            cmdFileCheckin = new CmdFileCheckin(this, string2, sender, n, this.getDirtyProperties(), bl, -1, syncUpdateType, n3, bl7, d, n2, mD5, bl5, new TypedResource_Marshaler(), this.getServer().getRepositoryID(), (FileRevisionID)object, bl8);
            cmdFileCheckin.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingClassID());
        }
        finally {
            Object var25_31 = null;
            sender.close();
        }
        object = cmdFileCheckin.getStatusData();
        if (!SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            try {
                this.discard();
                if (object != null) {
                    this.initializeReplicaValue(this.getPropertyNames().ROOT_OBJECT_ID, (Object)new Integer(((StStatusData)object).m_rootObjectID));
                    this.initializeReplicaValue(this.getPropertyNames().OBJECT_ID, (Object)new Integer(((StStatusData)object).m_objectID));
                    this.initializeReplicaValue(this.getPropertyNames().REVISION_NUMBER, (Object)new Integer(((StStatusData)object).m_version));
                }
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                Assert.internalError("File.checkinCore()", noSuchPropertyException);
            }
        }
        if (bl5) {
            keywords = new Keywords();
            keywords.setFrom(this, cmdFileCheckin.getKeywordValues(), cmdFileCheckin.getHistory(), this.getViews());
            keywordArray = keywords.getKeywords();
            this.expandKeywords(keywords.getKeywords(), file2);
        }
        if (bl3) {
            if (this.getServer().isSyncStoredLocally()) {
                StatusDataImpl statusDataImpl = new StatusDataImpl(this.getServer().getRepositoryID());
                statusDataImpl.initFromFile(this);
                statusDataImpl.setDotNotation(this.getDotNotation());
                statusDataImpl.setFileSize(file2.length());
                if (bl5) {
                    mD5.computeFileMD5(file2);
                }
                statusDataImpl.setFileMD5(mD5);
                statusDataImpl.setFileTime(Platform.getFileLastModified(file2));
                this.getServer().cacheStatusData(this.getParentFolder(), file2.getPath(), statusDataImpl);
            } else {
                this.updateStatusCore((StStatusData)object, file2);
            }
        }
        return new CheckInResult(keywordArray);
    }

    public void checkout(int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verifyNotDisembodied();
        this.checkoutCore(null, n, bl, bl2, bl3);
    }

    public void checkoutTo(java.io.File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verifyNotDisembodied();
        this.checkoutCore(file, n, bl, bl2, bl3);
    }

    public CheckOutResult checkoutToAndReturn(java.io.File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verifyNotDisembodied();
        return this.checkoutCore(file, n, bl, bl2, bl3);
    }

    public boolean checkoutByDate(java.io.File file, OLEDate oLEDate, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        boolean bl4;
        this.verifyNotDisembodied();
        File file2 = (File)this.getFromHistoryByDate(oLEDate);
        boolean bl5 = bl4 = file2 != null;
        if (bl4) {
            file2.checkoutTo(file, n, bl, bl2, bl3);
        }
        return bl4;
    }

    public boolean checkoutByLabelID(java.io.File file, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        boolean bl4;
        this.verifyNotDisembodied();
        File file2 = (File)this.getFromHistoryByLabelID(n);
        boolean bl5 = bl4 = file2 != null;
        if (bl4) {
            file2.checkoutTo(file, n2, bl, bl2, bl3);
        }
        return bl4;
    }

    public boolean checkoutByVersion(java.io.File file, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        boolean bl4;
        this.verifyNotDisembodied();
        File file2 = (File)this.getFromHistoryByVersion(n);
        boolean bl5 = bl4 = file2 != null;
        if (bl4) {
            file2.checkoutTo(file, n2, bl, bl2, bl3);
        }
        return bl4;
    }

    public void checkoutToStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        File file = this;
        synchronized (file) {
            Connection connection;
            String string;
            String string2 = string = bl ? this.getServer().getClientContext().getEOL() : null;
            if (this.isBinary()) {
                string = null;
            }
            boolean bl2 = this.usesKeywords();
            CheckOutStream checkOutStream = null;
            Connection connection2 = connection = this.getServer().useConnection();
            synchronized (connection2) {
                try {
                    checkOutStream = new CheckOutStream(this, n, string, bl2);
                    StreamUtils.bufferedTransfer(checkOutStream, outputStream, 4096);
                }
                finally {
                    Object var13_10 = null;
                    connection.commandNotInUse();
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    if (checkOutStream != null) {
                        checkOutStream.close();
                    }
                }
            }
        }
    }

    private CheckOutResult checkoutCore(java.io.File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        CheckOutResult checkOutResult = null;
        try {
            checkOutResult = this.checkoutImpl(file, n, bl, bl2, bl3);
        }
        catch (ConnectionException connectionException) {
            checkOutResult = this.handleCheckoutConnectionException(connectionException, file, n, bl, bl2, bl3);
        }
        catch (ForeignPasswordException foreignPasswordException) {
            checkOutResult = this.handleCheckoutForeignPasswordException(foreignPasswordException, file, n, bl, bl2, bl3);
        }
        return checkOutResult;
    }

    private CheckOutResult handleCheckoutConnectionException(ConnectionException connectionException, java.io.File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Server server = this.getServer();
        int n2 = server.getAutoReconnectAttempts();
        int n3 = server.getAutoReconnectWait() * 1000;
        int n4 = 0;
        while (n4 < n2) {
            try {
                Thread.currentThread();
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                server.reconnect();
                return this.checkoutImpl(file, n, bl, bl2, bl3);
            }
            catch (CommandException commandException) {
                connectionException.addReconnectException(commandException.getIOException());
                ++n4;
            }
        }
        throw connectionException;
    }

    private CheckOutResult handleCheckoutForeignPasswordException(ForeignPasswordException foreignPasswordException, java.io.File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Server server = this.getServer();
        Project project = this.getView().getProject();
        server.setForeignPassword(project);
        return this.checkoutImpl(file, n, bl, bl2, bl3);
    }

    private CheckOutResult checkoutImpl(java.io.File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        File file2 = this;
        synchronized (file2) {
            Object object;
            PropertyNames propertyNames;
            Object object2;
            Connection connection;
            String string;
            this.verifyNotDisembodied();
            Keyword[] keywordArray = new Keyword[]{};
            java.io.File file3 = file;
            if (file == null) {
                file3 = new java.io.File(this.getFullName());
            }
            if (file3.getParent() == null) {
                throw new IOException(Res.formatKey(ResIDs.CANNOT_WRITE_TO_FILE_FMT, new Object[]{file3}));
            }
            java.io.File file4 = new java.io.File(file3.getParent());
            if (!file4.exists()) {
                file4.mkdirs();
            }
            if (file3.exists() && !Platform.getFileWritable(file3)) {
                Platform.setFileWritable(file3, true);
            }
            StStatusData stStatusData = null;
            String string2 = string = bl2 ? this.getServer().getClientContext().getEOL() : null;
            if (this.isBinary()) {
                string = null;
            }
            boolean bl4 = this.usesKeywords();
            CheckOutStream checkOutStream = null;
            int n2 = 0;
            MD5 mD5 = new MD5();
            Connection connection2 = connection = this.getServer().useConnection();
            synchronized (connection2) {
                block27: {
                    object2 = null;
                    try {
                        checkOutStream = new CheckOutStream(this, n, string, bl4);
                        object2 = new FileOutputStream(file3);
                        n2 = StreamUtils.bufferedTransfer(checkOutStream, (OutputStream)object2, 4096, null);
                        if (checkOutStream.getKeywords() == null) break block27;
                        keywordArray = checkOutStream.getKeywords().getKeywords();
                    }
                    catch (Throwable throwable) {
                        Object var24_20 = null;
                        connection.commandNotInUse();
                        if (object2 != null) {
                            ((FileOutputStream)object2).close();
                        }
                        if (checkOutStream != null) {
                            checkOutStream.close();
                        }
                        throw throwable;
                    }
                }
                propertyNames = null;
                connection.commandNotInUse();
                if (object2 != null) {
                    ((FileOutputStream)object2).close();
                }
                if (checkOutStream != null) {
                    checkOutStream.close();
                }
            }
            stStatusData = checkOutStream.getStatusData();
            object2 = checkOutStream.getFileRevisionID();
            if (n != 3) {
                object = this.getType();
                propertyNames = this.getServer().getPropertyNames();
                Property property = ((Type)object).propertyForName(propertyNames.EXCLUSIVE_LOCKER);
                this.removeCachedServerCalculatedProperty(property);
                Property property2 = ((Type)object).propertyForName(propertyNames.NON_EXCLUSIVE_LOCKERS);
                this.removeCachedServerCalculatedProperty(property2);
                if (((Type)object).getServer().getRevisionLevel() < 72 && ((Type)object).hasPropertyForName(propertyNames.MY_LOCK)) {
                    Property property3 = ((Type)object).propertyForName(propertyNames.MY_LOCK);
                    this.removeCachedServerCalculatedProperty(property3);
                }
            }
            if (checkOutStream.getFileExecutable() && !Platform.getFileExecutable(file3)) {
                Platform.setFileExecutable(file3, true);
            }
            object = null;
            if (!bl) {
                try {
                    Platform.setFileLastModified(file3, checkOutStream.getFileTime());
                }
                catch (IOException iOException) {
                    object = iOException;
                }
            }
            if (bl3) {
                if (checkOutStream.getTransformsApplied() || checkOutStream.getSyncMD5() == null) {
                    mD5.computeFileMD5(file3);
                } else {
                    mD5 = checkOutStream.getSyncMD5();
                }
                this.updateStatusCore(stStatusData, (FileRevisionID)object2, file3, n2, mD5);
            }
            if (object != null) {
                throw object;
            }
            CheckOutResult checkOutResult = new CheckOutResult(keywordArray, checkOutStream.getExclusiveLockerID(), checkOutStream.getMyLockState());
            Object var7_28 = null;
            return checkOutResult;
        }
    }

    public void updateStatus(boolean bl, boolean bl2) throws IOException {
        this.verifyNotDisembodied();
        this.resyncStatusCore(null, bl, bl2);
    }

    private void resyncStatusCore(java.io.File file, boolean bl, boolean bl2) throws IOException {
        Object object;
        Object object2;
        java.io.File file2 = file;
        if (file == null) {
            file2 = new java.io.File(this.getFullName());
        }
        if (!file2.exists()) {
            return;
        }
        boolean bl3 = FileUtils.isBinary(file2);
        boolean bl4 = this.usesKeywords();
        boolean bl5 = bl;
        if (bl3) {
            bl5 = false;
        }
        String string = this.getName();
        double d = Platform.getFileLastModified(file2);
        int n = FileUtils.getFileLength(file2);
        MD5 mD5 = new MD5();
        mD5.computeFileMD5(file2);
        Folder folder = this.getParentFolder();
        int n2 = DestIDCache.getID(folder, file2.getParent());
        boolean bl6 = folder.getServer().getClientContext().getCaseSensitiveFileNames();
        CmdResyncFile cmdResyncFile = null;
        InputStream inputStream = null;
        try {
            object2 = FileStream.getSender(file2, bl3, bl4, bl5);
            if (bl2 || SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
                object = new MD5();
                int n3 = StreamUtils.eatStream(((FileStream.Sender)object2).getStream(), 1024, (MD5)object);
                cmdResyncFile = new CmdResyncFile(this, string, (MD5)object, n3, n2, bl6, d, n, mD5);
            } else {
                cmdResyncFile = new CmdResyncFile(this, string, (FileStream.Sender)object2, n2, bl6, d, n, mD5);
            }
            cmdResyncFile.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingComponentID());
        }
        finally {
            Object var19_20 = null;
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            object2 = cmdResyncFile.getFileRevisionID();
            if (((FileRevisionID)object2).isValid()) {
                object = new StatusDataImpl(this.getServer().getRepositoryID());
                ((StatusDataImpl)object).initFromFileRevisionID((FileRevisionID)object2);
                ((StatusDataImpl)object).setFileSize(n);
                ((StatusDataImpl)object).setFileMD5(mD5);
                ((StatusDataImpl)object).setFileTime(d);
                this.getServer().cacheStatusData(folder, file2.getPath(), (StatusDataImpl)object);
            }
        } else {
            object2 = new StatusDataImpl(cmdResyncFile.getStatusData());
            if (((StatusDataImpl)object2).isValid()) {
                this.getServer().cacheStatusData(folder, file2.getPath(), (StatusDataImpl)object2);
            }
        }
    }

    public void resyncStatus(MD5 mD5, int n, MD5 mD52, int n2, OLEDate oLEDate) {
        StatusDataImpl statusDataImpl = this.getStatusData(mD5, n, mD52, n2, oLEDate);
        if (statusDataImpl != null && statusDataImpl.isValid()) {
            Folder folder = this.getParentFolder();
            String string = this.getFullName();
            this.getServer().cacheStatusData(folder, string, statusDataImpl);
        }
    }

    public FileSyncInfo getFileSyncInfo(MD5 mD5, int n, MD5 mD52, int n2, OLEDate oLEDate) {
        StatusDataImpl statusDataImpl = this.getStatusData(mD5, n, mD52, n2, oLEDate);
        if (statusDataImpl != null && statusDataImpl.isValid()) {
            return statusDataImpl;
        }
        return null;
    }

    StatusDataImpl getStatusData(MD5 mD5, int n, MD5 mD52, int n2, OLEDate oLEDate) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        ClientContext clientContext = server.getClientContext();
        String string = this.getName();
        Folder folder = this.getParentFolder();
        String string2 = FileUtils.getParent(this.getFullName(), clientContext.getFilePathDelimiter());
        int n3 = DestIDCache.getID(folder, string2);
        boolean bl = clientContext.getCaseSensitiveFileNames();
        double d = oLEDate.getDoubleValue();
        CmdResyncFile cmdResyncFile = new CmdResyncFile(this, string, mD5, n, n3, bl, d, n2, mD52);
        cmdResyncFile.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(this.getView()).getID(), this.getRoutingComponentID());
        StatusDataImpl statusDataImpl = null;
        if (SystemRevisionNumbers.isClientManagedStatus(server.getRevisionLevel())) {
            FileRevisionID fileRevisionID = cmdResyncFile.getFileRevisionID();
            if (fileRevisionID.isValid()) {
                statusDataImpl = new StatusDataImpl(server.getRepositoryID());
                statusDataImpl.initFromFileRevisionID(fileRevisionID);
                statusDataImpl.setFileSize(n2);
                statusDataImpl.setFileMD5(mD52);
                statusDataImpl.setFileTime(d);
            }
        } else {
            statusDataImpl = new StatusDataImpl(cmdResyncFile.getStatusData());
        }
        return statusDataImpl;
    }

    public void removeAndDeleteLocal() throws IOException {
        this.verifyNotDisembodied();
        this.deleteCore(true);
    }

    private void deleteCore(boolean bl) throws IOException {
        if (bl) {
            this.verifyNotDisembodied();
        }
        super.remove();
        if (bl) {
            java.io.File file = new java.io.File(this.getFullName());
            this.deleteLocalFile(file);
        }
    }

    public boolean deleteLocalFile(java.io.File file) throws IOException {
        this.verifyNotDisembodied();
        if (file.isDirectory()) {
            throw new IOException(Res.formatKey(ResIDs.WILL_NOT_DELETE_DIRECTORY_FMT, new Object[]{file.getPath()}));
        }
        boolean bl = file.delete();
        if (bl) {
            this.deleteSyncInfo(file);
        }
        return bl;
    }

    public void deleteSyncInfo(java.io.File file) {
        this.verifyNotDisembodied();
        Folder folder = this.getParentFolder();
        this.getServer().deleteFileSyncInfo(folder, file.getPath(), this.getView());
    }

    public void lock() {
        super.lock();
    }

    public void unlock() {
        super.unlock();
    }

    public void putLock(int n, boolean bl) {
        super.putLock(n, bl);
    }

    public void updateStatusFromTime(int n, OLEDate oLEDate) {
        this.verifyNotDisembodied();
        this.updateStatusInformation(n, oLEDate, null);
    }

    public void updateStatusFromMD5(MD5 mD5) {
        this.verifyNotDisembodied();
        this.updateStatusInformation(-1, null, mD5);
    }

    public void updateStatusInformation(int n, OLEDate oLEDate, MD5 mD5) {
        boolean bl;
        this.verifyNotDisembodied();
        long l = n;
        String string = FileUtils.getAbsolutePath(this.getFullName());
        StatusDataImpl statusDataImpl = new StatusDataImpl(this.getServer().getRepositoryID());
        statusDataImpl.initFromFile(this);
        if (oLEDate == null) {
            oLEDate = new OLEDate(0.0);
        }
        FileSyncInfo fileSyncInfo = null;
        boolean bl2 = l < 0L;
        boolean bl3 = oLEDate.getDoubleValue() == 0.0;
        boolean bl4 = bl = mD5 == null;
        if (bl2 || bl3 || bl) {
            fileSyncInfo = this.prepareSyncInfo(string);
        }
        if (fileSyncInfo != null) {
            if (bl2) {
                l = fileSyncInfo.getFileDigest().getFileSize();
            }
            if (bl3) {
                oLEDate = new OLEDate(fileSyncInfo.getFileDigest().getFileTime());
            }
            if (bl) {
                mD5 = fileSyncInfo.getFileDigest().getFileMD5();
            }
        }
        if (mD5 == null) {
            mD5 = new MD5();
        }
        this.updateStatusCore(statusDataImpl, string, l, mD5, oLEDate.getDoubleValue());
    }

    private void updateStatusCore(StStatusData stStatusData, java.io.File file) throws IOException {
        StatusDataImpl statusDataImpl = new StatusDataImpl(stStatusData);
        statusDataImpl.setLocalFileInfo(file);
        this.updateStatusCore(statusDataImpl, file.getPath(), statusDataImpl.getFileSize(), statusDataImpl.getFileMD5(), statusDataImpl.getFileTime());
    }

    private void updateStatusCore(StStatusData stStatusData, FileRevisionID fileRevisionID, java.io.File file, long l, MD5 mD5) throws IOException {
        StatusDataImpl statusDataImpl;
        if (stStatusData == null) {
            statusDataImpl = new StatusDataImpl(this.getServer().getRepositoryID());
            statusDataImpl.initFromFileRevisionID(fileRevisionID);
        } else {
            statusDataImpl = new StatusDataImpl(stStatusData);
        }
        double d = Platform.getFileLastModified(file);
        this.updateStatusCore(statusDataImpl, file.getPath(), l, mD5, d);
    }

    public void updateStatusAfterMerge() throws IOException {
        this.verifyNotDisembodied();
        String string = this.getFullName();
        StatusDataImpl statusDataImpl = new StatusDataImpl(this.getServer().getRepositoryID());
        statusDataImpl.initFromFile(this);
        this.updateStatusCore(statusDataImpl, string, 0L, new MD5(), 0.0);
    }

    private void updateStatusCore(StatusDataImpl statusDataImpl, String string, long l, MD5 mD5, double d) {
        StStatusData stStatusData = statusDataImpl.getData();
        Folder folder = this.getParentFolder();
        String string2 = FileUtils.getParent(string, this.getServer().getClientContext().getFilePathDelimiter());
        boolean bl = folder.getServer().getClientContext().getCaseSensitiveFileNames();
        long l2 = Integer.MAX_VALUE;
        if (l > l2) {
            throw new RuntimeException(Res.formatKey(ResIDs.FILE_TOO_LARGE_FMT, new Object[]{new Long(l)}));
        }
        stStatusData.m_syncSize = (int)l;
        stStatusData.m_syncMD5 = mD5;
        stStatusData.m_syncTime = d;
        if (!this.getServer().isSyncStoredLocally()) {
            int n = DestIDCache.getID(folder, string2);
            CmdUpdateStatus cmdUpdateStatus = new CmdUpdateStatus(FileUtils.getName(string, this.getServer().getClientContext().getFilePathDelimiter()), stStatusData, bl, n, this.getServer().getRepositoryID());
            cmdUpdateStatus.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingComponentID());
            this.getServer().cacheStatusData(folder, string, new StatusDataImpl(cmdUpdateStatus.getNewStatusData()));
        } else {
            this.getServer().cacheStatusData(folder, string, statusDataImpl);
        }
    }

    public int getLastKnownVersionOnDisk() {
        this.verifyNotDisembodied();
        Folder folder = this.getParentFolder();
        String string = this.getFullName();
        folder.refreshSyncInfo(this.getTypeNames().FILE);
        FileSyncInfo fileSyncInfo = this.getServer().getFileSyncInfo(folder, string);
        if (fileSyncInfo == null) {
            return -1;
        }
        if (fileSyncInfo.getRevisionIdentifier().getRepositoryID().equals(this.getServer().getRepositoryID().canonicalFormat())) {
            return Item.getViewVersionFromDotNotation(fileSyncInfo.getRevisionIdentifier().getDotNotation());
        }
        return -1;
    }

    private FileSyncInfo getStatusData() {
        Folder folder = this.getParentFolder();
        String string = this.getFullName();
        folder.refreshSyncInfo(this.getTypeNames().FILE);
        return this.getServer().getFileSyncInfo(folder, string);
    }

    public int getStatus() throws IOException {
        if (this.isDisembodied()) {
            return 6;
        }
        return this.getStatus(new java.io.File(this.getFullName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStatus(java.io.File file) throws IOException {
        File file2 = this;
        synchronized (file2) {
            if (this.isNew()) {
                return 4;
            }
            if (!file.exists()) {
                return 2;
            }
            FileSyncInfo fileSyncInfo = this.prepareSyncInfo(file.getPath());
            RevisionIdentifier revisionIdentifier = this.prepareRevisionIdentifier();
            return Status.getStatusByTime(file, fileSyncInfo, revisionIdentifier);
        }
    }

    public int getSmartStatus() throws IOException {
        if (this.isDisembodied()) {
            return 6;
        }
        return this.getSmartStatus(new java.io.File(this.getFullName()));
    }

    public int getSmartStatus(java.io.File file) throws IOException {
        int n = this.getStatus(file);
        block0 : switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 1: 
            case 3: {
                int n2 = (int)file.length();
                if (n2 != this.getSyncLocalSize()) break;
                MD5 mD5 = new MD5();
                mD5.computeFileMD5(file);
                int n3 = this.getStatusByMD5(mD5);
                File file2 = null;
                switch (n3) {
                    case 5: {
                        file2 = (File)this.getFromHistoryByVersion(this.getLastKnownVersionOnDisk());
                    }
                    case 0: {
                        if (file2 == null) {
                            file2 = this;
                        }
                        OLEDate oLEDate = new OLEDate(Platform.getFileLastModified(file));
                        file2.updateStatusInformation(n2, oLEDate, mD5);
                        n = n3;
                        break block0;
                    }
                }
                break;
            }
        }
        return n;
    }

    public boolean upgradeSyncInfo() throws IOException {
        java.io.File file;
        FileSyncInfo fileSyncInfo;
        this.verifyNotDisembodied();
        if (!SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel()) && (fileSyncInfo = this.prepareSyncInfo((file = new java.io.File(this.getFullName())).getPath())) != null) {
            this.getServer().getFileBasedStatusManager(this.getView()).setFileSyncInfo(file, fileSyncInfo, this.getServer().getClientContext().getCaseSensitiveFileNames());
            return true;
        }
        return false;
    }

    private FileSyncInfo prepareSyncInfo(String string) {
        Folder folder = this.getParentFolder();
        folder.refreshSyncInfo(this.getTypeNames().FILE);
        return this.getServer().getFileSyncInfo(folder, string);
    }

    private RevisionIdentifier prepareRevisionIdentifier() {
        int n = this.getRootObjectID();
        int n2 = this.getContentVersion();
        int n3 = this.getObjectID();
        int n4 = this.getRevisionNumber();
        String string = this.getDotNotation();
        String string2 = this.getServer().getRepositoryID().canonicalFormat();
        File file = this;
        if (file == null) {
            throw null;
        }
        RevisionIdentifier revisionIdentifier = new RevisionIdentifier(file, string2, n, n3, n4, string, n2){
            private final /* synthetic */ File this$0;
            private final /* synthetic */ String val$serverID;
            private final /* synthetic */ int val$rootID;
            private final /* synthetic */ int val$objectID;
            private final /* synthetic */ int val$version;
            private final /* synthetic */ String val$dotNote;
            private final /* synthetic */ int val$contentVers;

            public String getRepositoryID() {
                return this.val$serverID;
            }

            public int getRootObjectID() {
                return this.val$rootID;
            }

            public void setRootObjectID(int n) {
            }

            public void setObjectID(int n) {
            }

            public void setRevisionNumber(int n) {
            }

            public int getObjectID() {
                return this.val$objectID;
            }

            public int getRevisionNumber() {
                return this.val$version;
            }

            public String getDotNotation() {
                return this.val$dotNote;
            }

            public void setDotNotation(String string) {
            }

            public int getContentRevision() {
                return this.val$contentVers;
            }

            public void setContentRevision(int n) {
            }
            {
                this.val$serverID = string;
                this.val$rootID = n;
                this.val$objectID = n2;
                this.val$version = n3;
                this.val$dotNote = string2;
                this.val$contentVers = n4;
                this.this$0 = file;
                this.constructor$0(file);
            }

            private final void constructor$0(File file) {
            }
        };
        return revisionIdentifier;
    }

    public int getStatusNow() throws IOException {
        if (this.isDisembodied()) {
            return 6;
        }
        return this.getStatusNow(new java.io.File(this.getFullName()));
    }

    int getStatusNow(java.io.File file) throws IOException {
        File file2 = this;
        synchronized (file2) {
            if (this.isDirty()) {
                throw new IllegalStateException(Res.getString(ResIDs.TO_AVOID_LOSS_OF_DATA));
            }
            this.discard();
            Folder folder = this.getParentFolder();
            folder.refreshSyncInfoNow();
            int n = this.getStatus(file);
            Object var3_5 = null;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLastKnownStatus() {
        File file = this;
        synchronized (file) {
            if (this.isDisembodied()) {
                return 6;
            }
            if (this.isNew()) {
                return 4;
            }
            String string = this.getFullName();
            FileSyncInfo fileSyncInfo = this.prepareSyncInfo(string);
            RevisionIdentifier revisionIdentifier = this.prepareRevisionIdentifier();
            return Status.getLastKnownStatus(fileSyncInfo, revisionIdentifier);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStatusByTime(int n, OLEDate oLEDate) {
        File file = this;
        synchronized (file) {
            if (this.isDisembodied()) {
                return 6;
            }
            if (this.isNew()) {
                return 4;
            }
            String string = this.getFullName();
            FileSyncInfo fileSyncInfo = this.prepareSyncInfo(string);
            RevisionIdentifier revisionIdentifier = this.prepareRevisionIdentifier();
            return Status.getStatusByTime(n, oLEDate.getDoubleValue(), fileSyncInfo, revisionIdentifier);
        }
    }

    public static boolean isInSyncByTime(java.io.File file, FileSyncInfo fileSyncInfo) throws IOException {
        boolean bl = false;
        if (file.exists()) {
            double d;
            FileDigest fileDigest;
            long l;
            double d2;
            long l2 = file.length();
            bl = !Status.hasFileChanged(l2, d2 = Platform.getFileLastModified(file), l = (fileDigest = fileSyncInfo.getFileDigest()).getFileSize(), d = fileDigest.getFileTime());
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStatusByMD5(MD5 mD5) {
        File file = this;
        synchronized (file) {
            if (this.isDisembodied()) {
                return 6;
            }
            if (this.isNew()) {
                return 4;
            }
            String string = this.getFullName();
            FileSyncInfo fileSyncInfo = this.prepareSyncInfo(string);
            RevisionIdentifier revisionIdentifier = this.prepareRevisionIdentifier();
            return Status.getStatusByMD5(mD5, fileSyncInfo, revisionIdentifier);
        }
    }

    public static boolean isInSyncByMD5(java.io.File file, FileSyncInfo fileSyncInfo) throws IOException {
        boolean bl = false;
        if (file.exists()) {
            MD5 mD5 = new MD5();
            mD5.computeFileMD5(file);
            FileDigest fileDigest = fileSyncInfo.getFileDigest();
            MD5 mD52 = fileDigest.getFileMD5();
            bl = !Status.hasFileChanged(mD5, mD52);
        }
        return bl;
    }

    private void renameCore() {
        String string = this.unsetDirtyComment();
        if (!this.isDirty()) {
            this.updateRevisionComment(string);
            return;
        }
        int n = 0;
        boolean bl = this.getServer().getClientContext().getCaseSensitiveFileNames();
        CmdFileUpdateProperty cmdFileUpdateProperty = new CmdFileUpdateProperty(this, this.getDirtyProperties(), string, SyncUpdateType.NOUPDATE, bl, n, new TypedResource_Marshaler());
        cmdFileUpdateProperty.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getRoutingClassID());
    }

    public Keyword[] getBlankKeywords() {
        return new Keywords().getKeywords();
    }

    void expandKeywords(Keyword[] keywordArray, java.io.File file) throws IOException {
        if (!this.usesKeywords()) {
            return;
        }
        boolean bl = true;
        TextInputStream textInputStream = new TextInputStream(new KeywordReader(new LineReader(new IdentityReader(new FileInputStream(file))), keywordArray, bl));
        String string = this.getServer().getClientContext().getFilePathDelimiter();
        java.io.File file2 = new java.io.File(FileUtils.getParent(file.getPath(), string), FileUtils.getName(file.getPath(), string) + ".tkw");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            StreamUtils.bufferedTransfer(textInputStream, fileOutputStream, 1024);
            ((InputStream)textInputStream).close();
            fileOutputStream.close();
            file.delete();
            file2.renameTo(file);
        }
        finally {
            Object var9_8 = null;
            ((InputStream)textInputStream).close();
            fileOutputStream.close();
            if (file2.exists()) {
                file2.delete();
            }
        }
    }

    public boolean usesKeywords() {
        this.verifyNotDisembodied();
        Project project = this.getView().getProject();
        if (project == null) {
            return false;
        }
        if (!project.isExpandKeywords()) {
            return false;
        }
        if (this.isNew() ? project.getProjectType() != 0 : this.getArchiveType() != 0) {
            return false;
        }
        String string = project.getKeywordExpansionFileExtensions();
        Folder folder = this.getParentFolder();
        boolean bl = folder.getServer().getClientContext().getCaseSensitiveFileNames();
        return FileUtils.matchPatternList(this.getName(), string, bl);
    }

    private View[] getViews() {
        return this.getView().getProject().getViews();
    }

    public String toString() {
        return this.getName();
    }

    public String getExtension() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return EMPTY_STRING;
        }
        if (n != string.length() - 1) {
            return string.substring(n + 1);
        }
        return EMPTY_STRING;
    }

    public boolean getStatusKnown() {
        if (this.isDisembodied()) {
            return false;
        }
        return this.getStatusData() != null;
    }

    public boolean getLocalFileExists() {
        if (this.isDisembodied()) {
            return false;
        }
        java.io.File file = new java.io.File(this.getFullName());
        return file.exists();
    }

    public boolean getLocalFileExecutable() throws IOException {
        if (this.isDisembodied()) {
            return false;
        }
        java.io.File file = new java.io.File(this.getFullName());
        return Platform.getFileExecutable(file);
    }

    public String getLocalName() throws IOException {
        if (this.isDisembodied()) {
            return EMPTY_STRING;
        }
        java.io.File file = new java.io.File(this.getFullName());
        return new java.io.File(file.getCanonicalPath()).getName();
    }

    public String getLocalPath() throws IOException {
        if (this.isDisembodied()) {
            return EMPTY_STRING;
        }
        java.io.File file = new java.io.File(this.getFullName());
        return new java.io.File(file.getCanonicalPath()).getParent();
    }

    public OLEDate getLocalTimeStamp() throws IOException {
        if (this.isDisembodied()) {
            return new OLEDate(0.0);
        }
        java.io.File file = new java.io.File(this.getFullName());
        if (file.exists()) {
            return new OLEDate(Platform.getFileLastModified(file));
        }
        return new OLEDate(0.0);
    }

    public int getLocalSize() {
        if (this.isDisembodied()) {
            return -1;
        }
        java.io.File file = new java.io.File(this.getFullName());
        if (file.exists()) {
            return (int)file.length();
        }
        return -1;
    }

    boolean getSyncOnPathToRoot() {
        if (this.isDisembodied()) {
            return false;
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return false;
        }
        String string = fileSyncInfo.getRevisionIdentifier().getDotNotation();
        String string2 = this.getDotNotation();
        return Status.getSyncOnPathToRoot(string, string2);
    }

    int getSyncBranchVersion() {
        if (this.isDisembodied()) {
            return -1;
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return -1;
        }
        return Item.getBranchRevisionFromDotNotation(fileSyncInfo.getRevisionIdentifier().getDotNotation());
    }

    int getSyncContentVersion() {
        if (this.isDisembodied()) {
            return -1;
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return -1;
        }
        return fileSyncInfo.getRevisionIdentifier().getContentRevision();
    }

    int getSyncPathVersion() {
        if (this.isDisembodied()) {
            return -1;
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return -1;
        }
        return Item.getViewVersionFromDotNotation(fileSyncInfo.getRevisionIdentifier().getDotNotation());
    }

    int getSyncLocalSize() {
        if (this.isDisembodied()) {
            return -1;
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return -1;
        }
        return (int)fileSyncInfo.getFileDigest().getFileSize();
    }

    OLEDate getSyncTime() {
        if (this.isDisembodied()) {
            return new OLEDate(0.0);
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return new OLEDate(0.0);
        }
        return new OLEDate(fileSyncInfo.getFileDigest().getFileTime());
    }

    MD5 getSyncMD5() {
        if (this.isDisembodied()) {
            return new MD5();
        }
        FileSyncInfo fileSyncInfo = this.getStatusData();
        if (fileSyncInfo == null) {
            return new MD5();
        }
        return fileSyncInfo.getFileDigest().getFileMD5();
    }

    protected String getDisembodiedMessage() {
        return Res.getString(ResIDs.DISEMBODIED_FILE_OPERATION);
    }

    File(Server server, View view) {
        super(server.getTypeNames().FILE, server, view);
    }

    public File(Folder folder) {
        super(folder.getTypeNames().FILE, folder.getServer(), folder.getView());
        this.setParentFolder(folder);
    }

    File(Server server, View view, int n) {
        super(server.getTypeNames().FILE, server, view, n);
    }
}

