/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Translations;
import com.starbase.util.Assert;

public class EnumeratedValue {
    private int m_code;
    private String m_description = null;
    private boolean m_enabled = true;
    private Translations m_translations = null;

    public int getCode() {
        return this.m_code;
    }

    public void setCode(int n) {
        this.m_code = n;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        if (string == null) {
            Assert.nullArgument("String", "description");
        }
        if (this.m_description == null) {
            throw new IllegalStateException(ResIDs.ENUMERATED_VALUE_NO_DESCRIPTION);
        }
        this.m_description = string;
    }

    public Translations getTranslations() {
        return this.m_translations;
    }

    public void setTranslations(Translations translations) {
        if (translations == null) {
            Assert.nullArgument("Translations", "translations");
        }
        if (this.m_translations == null) {
            throw new IllegalStateException(ResIDs.ENUMERATED_VALUE_NO_TRANSLATIONS);
        }
        this.m_translations = translations;
    }

    public String getDisplayName() {
        if (this.m_description != null) {
            return this.m_description;
        }
        return this.m_translations.translate();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public EnumeratedValue copy() {
        EnumeratedValue enumeratedValue = new EnumeratedValue();
        enumeratedValue.m_code = this.m_code;
        enumeratedValue.m_enabled = this.m_enabled;
        enumeratedValue.m_description = this.m_description;
        enumeratedValue.m_translations = this.m_translations != null ? this.m_translations.copy() : null;
        return enumeratedValue;
    }

    boolean isOldStyle() {
        return this.m_description != null;
    }

    private EnumeratedValue() {
    }

    public EnumeratedValue(int n, String string) {
        if (string == null) {
            Assert.nullArgument("String", "description");
        }
        this.m_code = n;
        this.m_description = string;
        this.m_translations = null;
    }

    public EnumeratedValue(int n, Translations translations) {
        if (translations == null) {
            Assert.nullArgument("Translations", "translations");
        }
        this.m_code = n;
        this.m_translations = translations;
        this.m_description = null;
    }
}

