/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.Group;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.ISecurable;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource;
import com.starbase.starteam.User;
import com.starbase.util.Assert;

public class EffectiveACE
extends AclEntry {
    static final int ID_ALL_USERS = Integer.MIN_VALUE;
    static final int ALL_PERMISSIONS = -1;
    private static final int UNKNOWN = 0;
    private static final int GROUP_PRIVILEGES = 1;
    private static final int OBJECT_OWNERSHIP = 2;
    private static final int OBJECT_ACL = 3;
    private static final int CONTAINER_ACL = 4;
    private static final int MISSING_ACE = 5;
    private static final int MISSING_ACL = 6;
    private static final String EMPTY = "";
    private Server m_server = null;
    private int m_type = 0;
    private ISecurable m_object = null;
    private ISecurableContainer m_container = null;
    private Type m_objtype = null;

    static EffectiveACE forGroupPrivileges(Server server, GroupAccount groupAccount) {
        return new EffectiveACE(server, groupAccount.getID(), true, groupAccount.getPermissionsFlags(), 1);
    }

    static EffectiveACE forOwner(Server server, int n, ISecurable iSecurable) {
        EffectiveACE effectiveACE = new EffectiveACE(server, n, true, -1, 2);
        effectiveACE.m_object = iSecurable;
        return effectiveACE;
    }

    static EffectiveACE forObjectACE(Server server, AclEntry aclEntry, ISecurable iSecurable) {
        EffectiveACE effectiveACE = new EffectiveACE(server, aclEntry, 3);
        effectiveACE.m_object = iSecurable;
        return effectiveACE;
    }

    static EffectiveACE forContainerACE(Server server, AclEntry aclEntry, ISecurableContainer iSecurableContainer, Type type) {
        EffectiveACE effectiveACE = new EffectiveACE(server, aclEntry, 4);
        effectiveACE.m_container = iSecurableContainer;
        effectiveACE.m_objtype = type;
        return effectiveACE;
    }

    static EffectiveACE forMissingACE(Server server, int n) {
        return new EffectiveACE(server, Integer.MIN_VALUE, false, n, 5);
    }

    static EffectiveACE forMissingACL(Server server) {
        return new EffectiveACE(server, Integer.MIN_VALUE, true, -1, 6);
    }

    public boolean isFromGroupPrivileges() {
        return this.m_type == 1;
    }

    public boolean isFromObjectOwnership() {
        return this.m_type == 2;
    }

    public boolean isFromObjectACL() {
        return this.m_type == 3;
    }

    public boolean isFromContainerACL() {
        return this.m_type == 4;
    }

    public boolean isFromMissingACE() {
        return this.m_type == 5;
    }

    public boolean isFromMissingACL() {
        return this.m_type == 6;
    }

    public Group getGroup() {
        return this.m_server.getGroup(this.getID());
    }

    public User getUser() {
        return this.m_server.getUser(this.getID());
    }

    public String getUserOrGroupName() {
        User user = this.getUser();
        if (user != null) {
            return user.getName();
        }
        Group group = this.getGroup();
        if (group != null) {
            return group.getName();
        }
        return EMPTY;
    }

    public ISecurable getObject() {
        return this.m_object;
    }

    public ISecurableContainer getContainer() {
        return this.m_container;
    }

    public Type getObjectType() {
        if (this.isFromContainerACL()) {
            if (this.m_objtype == null) {
                Assert.internalError("EffectiveACE.getObjectType()");
            }
            return this.m_objtype;
        }
        ISecurable iSecurable = this.getObject();
        if (iSecurable != null) {
            return iSecurable.getType();
        }
        return null;
    }

    public boolean isExplicitACE() {
        return this.isFromObjectACL() || this.isFromContainerACL();
    }

    public boolean isImpliedACE() {
        return !this.isExplicitACE();
    }

    public String getDescription() {
        String string = EMPTY;
        if (this.m_type == 1) {
            Object[] objectArray = new Object[]{this.getAccountDescription()};
            string = Res.formatKey(ResIDs.ACE_GROUP_PRIVILEGES_FMT, objectArray);
        } else if (this.m_type == 2) {
            ISecurable iSecurable;
            User user = this.getUser();
            if (user == null) {
                Assert.internalError("EffectiveACE.getDescription(), user=null");
            }
            if ((iSecurable = this.getObject()) == null) {
                Assert.internalError("EffectiveACE.getDescription(), owned.obj=null");
            }
            Object[] objectArray = new Object[]{user.getName(), this.getDescription(iSecurable)};
            string = Res.formatKey(ResIDs.ACE_OBJECT_OWNERSHIP_FMT, objectArray);
        } else if (this.m_type == 3) {
            ISecurable iSecurable = this.getObject();
            if (iSecurable == null) {
                Assert.internalError("EffectiveACE.getDescription(), acl.obj=null");
            }
            Object[] objectArray = new Object[]{this.getGrantedOrDenied(), this.getAccountDescription(), this.getDescription(iSecurable)};
            string = Res.formatKey(ResIDs.ACE_OBJECT_ACL_FMT, objectArray);
        } else if (this.m_type == 4) {
            Type type;
            ISecurableContainer iSecurableContainer = this.getContainer();
            if (iSecurableContainer == null) {
                Assert.internalError("EffectiveACE.getDescription(), container=null");
            }
            if ((type = this.getObjectType()) == null) {
                Assert.internalError("EffectiveACE.getDescription(), type=null");
            }
            Object[] objectArray = new Object[]{this.getGrantedOrDenied(), this.getAccountDescription(), type.getDisplayName(), this.getDescription(iSecurableContainer)};
            string = Res.formatKey(ResIDs.ACE_CONTAINER_ACL_FMT, objectArray);
        } else if (this.m_type == 5) {
            string = Res.getString(ResIDs.ACE_MISSING);
        } else if (this.m_type == 6) {
            string = Res.getString(ResIDs.ACE_MISSING_ACL);
        } else {
            Assert.internalError("EffectiveACE.getDescription(), type=" + this.m_type);
        }
        return string;
    }

    private String getDescription(ISecurableContainer iSecurableContainer) {
        if (iSecurableContainer instanceof TypedResource) {
            return this.getDescription((TypedResource)((Object)iSecurableContainer));
        }
        return Res.getString(ResIDs.GENERIC_PARENT_CONTAINER);
    }

    private String getDescription(ISecurable iSecurable) {
        if (iSecurable instanceof TypedResource) {
            return this.getDescription((TypedResource)((Object)iSecurable));
        }
        Type type = iSecurable.getType();
        Object[] objectArray = new Object[]{type.getDisplayName()};
        return Res.formatKey(ResIDs.GENERIC_INSTANCE_OF_TYPE_FMT, objectArray);
    }

    private String getDescription(TypedResource typedResource) {
        String string;
        Type type = typedResource.getType();
        String string2 = type.getDisplayName();
        Property property = null;
        Object object = null;
        Property[] propertyArray = type.getDescriptors();
        if (propertyArray != null && propertyArray.length > 0) {
            property = propertyArray[0];
            object = typedResource.get(property.getName());
        }
        if (object == null) {
            Object[] objectArray = new Object[]{string2};
            string = Res.formatKey(ResIDs.GENERIC_INSTANCE_OF_TYPE_FMT, objectArray);
        } else if (object instanceof Integer) {
            Object[] objectArray = new Object[]{string2, object};
            string = Res.formatKey(ResIDs.INSTANCE_OF_TYPE_WITH_NUMERIC_NAME_FMT, objectArray);
        } else {
            object = property.getDisplayValue(object);
            Object[] objectArray = new Object[]{string2, object};
            string = Res.formatKey(ResIDs.INSTANCE_OF_TYPE_WITH_STRING_NAME_FMT, objectArray);
        }
        return string;
    }

    private String getGrantedOrDenied() {
        if (this.isGranted()) {
            return Res.getString(ResIDs.GRANTED);
        }
        return Res.getString(ResIDs.DENIED);
    }

    private String getAccountDescription() {
        User user = this.getUser();
        if (user != null) {
            Object[] objectArray = new Object[]{user.getName()};
            return Res.formatKey(ResIDs.USER_DESCRIPTION_FMT, objectArray);
        }
        Group group = this.getGroup();
        if (group != null) {
            Object[] objectArray = new Object[]{group.getName()};
            return Res.formatKey(ResIDs.GROUP_MEMBERS_DESCRIPTION_FMT, objectArray);
        }
        Assert.internalError("EffectiveACE.getAccountDescription()");
        return EMPTY;
    }

    private EffectiveACE(Server server, AclEntry aclEntry, int n) {
        this(server, aclEntry.getID(), aclEntry.isGranted(), aclEntry.getPermissionFlags(), n);
    }

    private EffectiveACE(Server server, int n, boolean bl, int n2, int n3) {
        super(n, bl);
        this.addPermission(n2);
        this.m_server = server;
        this.m_type = n3;
    }
}

