/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdGetPathIDs;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.util.FileUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DestIDCache {
    public static void populate(Vector vector) {
        int n;
        String[] stringArray;
        if (vector.isEmpty()) {
            return;
        }
        Server server = ((Folder)vector.firstElement()).getServer();
        if (server.isSyncStoredLocally()) {
            return;
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            String string = DestIDCache.getPath((Folder)stringArray, stringArray.getPath());
            n = DestIDCache.findID(server, string);
            if (n != -1) continue;
            vector2.addElement(string);
        }
        if (vector2.isEmpty()) {
            return;
        }
        stringArray = new String[vector2.size()];
        int n2 = 0;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray[n2++] = string;
        }
        n = server.getClientContext().getCaseSensitiveFileNames() ? 1 : 0;
        DestIDCache.fetchIDsFromServer(stringArray, n != 0, server);
    }

    public static int getID(Folder folder, String string) {
        if (folder.getServer().isSyncStoredLocally()) {
            return -1;
        }
        String string2 = DestIDCache.getPath(folder, string);
        Server server = folder.getServer();
        int n = DestIDCache.findID(server, string2);
        if (n == -1) {
            return DestIDCache.fetchIDs(folder, string2);
        }
        return n;
    }

    public static int getID(Server server, Folder folder, String string) {
        if (server.isSyncStoredLocally()) {
            return -1;
        }
        String string2 = DestIDCache.getPath(folder, string);
        int n = DestIDCache.findID(server, string2);
        if (n == -1) {
            String[] stringArray = new String[]{string2};
            DestIDCache.fetchIDsFromServer(stringArray, server.getClientContext().getCaseSensitiveFileNames(), server);
            return DestIDCache.findID(server, string2);
        }
        return n;
    }

    private static String getPath(Folder folder) {
        String string = folder.getPath();
        return DestIDCache.getPath(folder, string);
    }

    private static String getPath(Folder folder, String string) {
        boolean bl = folder.getServer().getClientContext().getCaseSensitiveFileNames();
        return FileUtils.getCanonicalPathName(FileUtils.getAbsolutePath(string), bl);
    }

    private static int findID(Server server, String string) {
        Object var2_2 = null;
        Hashtable hashtable = server.getDestIDCache();
        var2_2 = hashtable.get(string);
        if (var2_2 == null) {
            return -1;
        }
        return var2_2;
    }

    private static int fetchIDs(Folder folder, String string) {
        Object object;
        Object object2;
        Vector vector = new Vector();
        DestIDCache.gatherFolders2(folder, vector);
        int n = 0;
        int n2 = 0;
        if (folder.getServer().getClientContext().getCaseSensitiveFileNames()) {
            ++n;
        } else {
            ++n2;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Folder)enumeration.nextElement();
            boolean bl = ((Item)object2).getServer().getClientContext().getCaseSensitiveFileNames();
            if (bl) {
                ++n;
                continue;
            }
            ++n2;
        }
        object2 = new String[n];
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = 0;
        if (folder.getServer().getClientContext().getCaseSensitiveFileNames()) {
            object2[n3++] = string;
        } else {
            stringArray[n4++] = string;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Folder)enumeration.nextElement();
            if (((Item)object).getServer().getClientContext().getCaseSensitiveFileNames()) {
                object2[n3++] = DestIDCache.getPath((Folder)object);
                continue;
            }
            stringArray[n4++] = DestIDCache.getPath((Folder)object);
        }
        object = folder.getServer();
        DestIDCache.fetchIDsFromServer((String[])object2, true, (Server)object);
        DestIDCache.fetchIDsFromServer(stringArray, false, (Server)object);
        return DestIDCache.findID((Server)object, string);
    }

    private static void fetchIDsFromServer(String[] stringArray, boolean bl, Server server) {
        if (stringArray.length == 0) {
            return;
        }
        int n = server.getComponentID(ServerComponentInfo.FILE);
        CmdGetPathIDs cmdGetPathIDs = new CmdGetPathIDs(stringArray, bl);
        cmdGetPathIDs.execute(server.useConnection(), server.getSession().getID(), 0, n);
        int[] nArray = cmdGetPathIDs.getPathIDs();
        int n2 = 0;
        while (n2 < stringArray.length) {
            DestIDCache.cacheID(server, stringArray[n2], nArray[n2]);
            ++n2;
        }
    }

    private static void cacheID(Server server, String string, int n) {
        Hashtable hashtable = server.getDestIDCache();
        hashtable.put(string, new Integer(n));
    }

    private static void gatherFolders(Folder folder, Vector vector) {
        if (DestIDCache.getFolderID(folder) == -1) {
            vector.addElement(folder);
        }
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            DestIDCache.gatherFolders(folderArray[n], vector);
            ++n;
        }
    }

    private static void addToGather(Folder folder, Vector vector) {
        if (folder != null && DestIDCache.getFolderID(folder) == -1) {
            vector.addElement(folder);
        }
    }

    private static void gatherFolders2(Folder folder, Vector vector) {
        int n;
        Folder[] folderArray;
        if (folder.getParentFolder() == null) {
            DestIDCache.addToGather(folder, vector);
        } else {
            DestIDCache.addToGather(folder.getParentFolder(), vector);
            folderArray = folder.getParentFolder().getSubFolders();
            n = 0;
            while (n < folderArray.length) {
                DestIDCache.addToGather(folderArray[n], vector);
                ++n;
            }
        }
        folderArray = folder.getSubFolders();
        n = 0;
        while (n < folderArray.length) {
            DestIDCache.addToGather(folderArray[n], vector);
            ++n;
        }
    }

    private static int getFolderID(Folder folder) {
        String string = DestIDCache.getPath(folder);
        Server server = folder.getServer();
        return DestIDCache.findID(server, string);
    }

    DestIDCache() {
    }
}

