/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.CacheRefCollection;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.DescriptorCache;
import com.starbase.starteam.ObjectDescriptors;
import com.starbase.starteam.Server;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DescriptorCacheRefCollection
extends CacheRefCollection {
    private boolean m_bPopulated = false;

    public void populate() {
        if (!this.m_bPopulated) {
            this.refreshAll();
        }
    }

    public void refreshIDs(int[] nArray) {
        Cacheable[] cacheableArray;
        int n = 0;
        Vector<Cacheable[]> vector = new Vector<Cacheable[]>();
        Vector<Integer> vector2 = new Vector<Integer>();
        n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            cacheableArray = this.getByID(n2);
            if (cacheableArray == null) {
                vector2.addElement(new Integer(n2));
            } else {
                vector.addElement(cacheableArray);
            }
            ++n;
        }
        this.m_cache.refresh(this.m_repository, vector);
        int[] nArray2 = new int[vector2.size()];
        n = 0;
        while (n < nArray2.length) {
            nArray2[n] = (Integer)vector2.elementAt(n);
            ++n;
        }
        cacheableArray = this.m_cache.get(this.m_repository, nArray2);
        n = 0;
        while (n < cacheableArray.length) {
            if (cacheableArray[n] != null) {
                this.m_refs.addElement(this.m_cache.newCacheRef(this.m_repository, cacheableArray[n]));
            }
            ++n;
        }
        this.m_timestamp = this.m_cache.getParent().getTimestamp();
    }

    public void refreshAll() {
        this.m_timestamp = this.m_cache.refreshAll(this.m_repository, this.m_refs, this.m_timestamp);
        this.m_bPopulated = true;
    }

    public boolean isRefreshAllRequired() {
        return this.m_cache.isRefreshAllRequired(this.m_refs, this.m_timestamp);
    }

    public CacheRef getByID(int n) {
        this.refreshHashtable();
        return (ObjectDescriptors)this.m_idHashedRefs.get(new Integer(n));
    }

    public void refresh() {
        Assert.internalError("DescriptorCacheRefCollection.refresh()");
    }

    public boolean isRefreshRequired() {
        Assert.internalError("DescriptorCacheRefCollection.isRefreshRequired()");
        return false;
    }

    public boolean isRefreshIDsRequired(int[] nArray) {
        Vector<CacheRef> vector = new Vector<CacheRef>();
        int n = 0;
        while (n < nArray.length) {
            CacheRef cacheRef = this.getByID(nArray[n]);
            if (cacheRef == null) {
                return true;
            }
            vector.addElement(cacheRef);
            ++n;
        }
        return this.m_cache.isRefreshRequired(vector);
    }

    public Hashtable getCachedIDs() {
        this.refreshHashtable();
        return this.m_idHashedRefs;
    }

    public int[] getPropertyIDs() {
        return ((DescriptorCache)this.m_cache).getPropertyIDs(this.m_repository);
    }

    private long getLastModified() {
        return Math.max(this.m_timestamp, this.m_cache.getLastModified());
    }

    private void refreshHashtable() {
        if (this.m_refs.size() > 0 && this.m_idHashtableTimestamp < this.getLastModified()) {
            this.m_idHashedRefs = new Hashtable(this.m_refs.size());
            Enumeration enumeration = this.m_refs.elements();
            while (enumeration.hasMoreElements()) {
                CacheRef cacheRef = (CacheRef)enumeration.nextElement();
                int n = cacheRef.getCachedObject().getID();
                this.m_idHashedRefs.put(new Integer(n), cacheRef);
            }
            this.m_idHashtableTimestamp = this.getLastModified();
        }
    }

    public DescriptorCacheRefCollection(DescriptorCache descriptorCache, Server server) {
        super(descriptorCache, server);
    }
}

