/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdMacroGlobalServiceCommand;
import com.starbase.starteam.Server;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Hashtable;

class CmdGetUsersAndGroups
extends CmdMacroGlobalServiceCommand {
    public static final int USERSONLY = 1;
    public static final int GROUPSONLY = 2;
    public static final int USERSANDGROUPS = 3;
    private static final CommandRoute m_route = new CommandRoute(0x40000000, 0, 2001, "SRVR_CMD_GET_USERS_AND_GROUPS");
    private int[] m_ids;
    private String[] m_names;
    private int m_which;
    private boolean m_deleted;
    private boolean[] m_isCurrent = null;

    protected boolean isRetrySupported() {
        return true;
    }

    public int[] getIDs() {
        return this.m_ids;
    }

    public String[] getNames() {
        return this.m_names;
    }

    public Hashtable getIDtoNameMap() {
        int n = this.m_ids.length;
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>(n);
        int n2 = 0;
        while (n2 < n) {
            hashtable.put(new Integer(this.m_ids[n2]), this.m_names[n2]);
            ++n2;
        }
        return hashtable;
    }

    protected void push(Command command) throws IOException {
        command.writeInt(this.m_which);
        command.writeBoolean(!this.m_deleted);
    }

    protected void pop(Command command) throws IOException {
        int n = command.readInt();
        this.m_ids = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_ids[n2] = command.readInt();
            ++n2;
        }
        n2 = command.readInt();
        if (n2 != n) {
            Assert.internalError("CmdGetUsersAndGroups.pop(), namecount=" + n2 + ", count=" + n + ".");
        }
        this.m_names = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string;
            this.m_names[n3] = string = command.readString();
            ++n3;
        }
        if (command.supports((short)100, "1.14") && this.m_deleted) {
            n3 = command.readInt();
            if (n2 != n) {
                Assert.internalError("CmdGetUsersAndGroups.pop(), statuscount=" + n3 + ", count=" + n + ".");
            }
            this.m_isCurrent = new boolean[n];
            int n4 = 0;
            while (n4 < n3) {
                short s = command.readShort();
                this.m_isCurrent[n4] = s != 0;
                ++n4;
            }
        }
    }

    public boolean isCurrent(int n) {
        if (!this.m_deleted) {
            return true;
        }
        if (this.m_isCurrent != null) {
            if (n < 0 || n >= this.m_isCurrent.length) {
                Assert.internalError("CmdGetUsersAndGroups.isCurrent(), index=" + n + "; length=" + this.m_isCurrent.length);
            }
            return this.m_isCurrent[n];
        }
        Assert.internalError("CmdGetUsersAndGroups.isCurrent(), m_isCurrent=null");
        return false;
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdGetUsersAndGroups(Server server, int n, boolean bl) {
        super(server, 65535);
        this.m_which = n;
        this.m_deleted = bl;
    }
}

