/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdMacroSecureServerCommand;
import com.starbase.starteam.Server;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandRoute;
import java.io.IOException;

class CmdGetGroupMemberIDs
extends CmdMacroSecureServerCommand {
    private static final CommandRoute m_route = new CommandRoute(0x40000000, 0, 2060, "SRVR_CMD_GET_GROUP_MEMBERS");
    private int m_groupID = -1;
    private int m_nSize = -1;
    private int[] m_IDs = null;
    private int[] m_parentIDs = null;
    private int[][] m_memberIDs = null;

    protected boolean isRetrySupported() {
        return true;
    }

    public int[] getIDs() {
        return this.m_IDs;
    }

    public int[] getParentIDs() {
        return this.m_parentIDs;
    }

    public int[][] getMemberIDs() {
        return this.m_memberIDs;
    }

    private void initializeIDArrays() {
        this.m_IDs = new int[this.m_nSize];
        this.m_parentIDs = new int[this.m_nSize];
        this.m_memberIDs = new int[this.m_nSize][];
    }

    private void popByIndex(Command command, int n) throws IOException {
        this.m_IDs[n] = command.readInt();
        this.m_parentIDs[n] = command.readInt();
        this.m_memberIDs[n] = command.readIntArray();
    }

    protected void push(Command command) throws IOException {
        command.writeInt(this.m_groupID);
    }

    protected void pop(Command command) throws IOException {
        if (this.m_groupID == -1) {
            this.m_nSize = command.readInt();
            this.initializeIDArrays();
            int n = 0;
            while (n < this.m_nSize) {
                this.popByIndex(command, n);
                ++n;
            }
        } else {
            this.m_nSize = 1;
            this.initializeIDArrays();
            this.popByIndex(command, 0);
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdGetGroupMemberIDs(Server server) {
        super(server, true);
    }

    public CmdGetGroupMemberIDs(Server server, int n) {
        super(server, true);
        this.m_groupID = n;
    }
}

