/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.Property;
import com.starbase.starteam.SyncUpdateType;
import com.starbase.starteam.TypedResource_Marshaler;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.util.OLEDate;
import java.io.IOException;

class CmdFileUpdateProperty
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 524288, 2004, "PROJ_CMD_UPDATE_ITEM");
    private Item m_item;
    private Property[] m_unsavedProperties;
    private int m_newVMID;
    private String m_reason = "";
    private SyncUpdateType m_syncUpdateType = null;
    private boolean m_caseSensitive = false;
    private int m_destID = -1;
    private TypedResource_Marshaler m_marshaler;

    public int getItemID() {
        return this.m_newVMID;
    }

    protected boolean isRetrySupported() {
        return this.isRetrySupportedForEditCommand();
    }

    protected void push(Command command) throws IOException {
        command.writeInt(0);
        command.writeInt(this.m_item.getItemID());
        command.writeInt(this.m_item.isDisembodied() ? -1 : this.m_item.getParentFolder().getItemID());
        this.m_marshaler.writeItemProperties(this.m_item, this.m_unsavedProperties, command);
        command.writeString(this.m_reason);
        OLEDate oLEDate = this.m_item.getSnapshotTime();
        command.writeTime(oLEDate.getDoubleValue());
        command.writeInt(1);
        if (!SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            command.writeInt(this.m_syncUpdateType.getCode());
            command.writeBoolean(this.m_caseSensitive);
            command.writeInt(this.m_destID);
        }
    }

    protected void pop(Command command) throws IOException {
        this.m_newVMID = command.readInt();
        double d = command.readTime();
        this.m_item.setSnapshotTime(new OLEDate(d));
        if (SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            this.m_marshaler.readItem(this.m_item, command);
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdFileUpdateProperty(Item item, Property[] propertyArray, String string, SyncUpdateType syncUpdateType, boolean bl, int n, TypedResource_Marshaler typedResource_Marshaler) {
        this.m_marshaler = typedResource_Marshaler;
        this.m_item = item;
        this.m_unsavedProperties = propertyArray;
        this.m_reason = string;
        this.m_caseSensitive = bl;
        this.m_destID = n;
        this.m_syncUpdateType = syncUpdateType;
    }
}

