/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheManager;
import com.starbase.starteam.ClientContext;
import com.starbase.starteam.Server;
import com.starbase.util.GUID;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class CacheManagerCollection {
    private static Hashtable m_cache = new Hashtable();
    private static long m_timestamp = 0L;
    private static int m_nMaxCaches = 0;

    protected abstract String getKey(Server var1);

    protected abstract CacheManager newCacheManager(Server var1);

    protected static String getRepositoryKey(Server server) {
        return server.getAddress() + ":" + server.getPort();
    }

    protected static String getWorkstationKey(Server server) {
        ClientContext clientContext = server.getClientContext();
        GUID gUID = clientContext.getWorkStationID();
        return CacheManagerCollection.getRepositoryKey(server) + ":" + gUID.canonicalFormat();
    }

    protected synchronized CacheManager get(Server server) {
        String string = this.getKey(server);
        CacheManager cacheManager = (CacheManager)m_cache.get(string);
        if (cacheManager == null) {
            cacheManager = this.newCacheManager(server);
            m_cache.put(string, cacheManager);
        }
        return cacheManager;
    }

    public static synchronized void addRef(CacheManager cacheManager) {
        cacheManager.addRef();
    }

    public static synchronized void touch(CacheManager cacheManager) {
        cacheManager.setLastReferenced(++m_timestamp);
    }

    public static synchronized void release(CacheManager cacheManager) {
        if (cacheManager.release() <= 0) {
            CacheManagerCollection.checkCaches();
        }
    }

    public static int getMaxCaches() {
        return m_nMaxCaches;
    }

    public static void setMaxCaches(int n) {
        if (n < 0) {
            n = 0;
        }
        boolean bl = n < m_nMaxCaches;
        m_nMaxCaches = n;
        if (bl) {
            CacheManagerCollection.checkCaches();
        }
    }

    private static synchronized void checkCaches() {
        int n;
        do {
            n = 0;
            CacheManager cacheManager = null;
            Object var2_2 = null;
            long l = 0L;
            Enumeration enumeration = m_cache.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                CacheManager cacheManager2 = (CacheManager)m_cache.get(k);
                if (cacheManager2.getReferenceCount() > 0) continue;
                long l2 = cacheManager2.getLastReferenced();
                if (cacheManager == null || l2 < l) {
                    cacheManager = cacheManager2;
                    var2_2 = k;
                    l = l2;
                }
                ++n;
            }
            if (n <= m_nMaxCaches) continue;
            m_cache.remove(var2_2);
            cacheManager.discard();
            --n;
        } while (n > m_nMaxCaches);
    }
}

