/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.vts.pickle.ACE;

public class AclEntry {
    private int m_flags = 0;
    private int m_id = -1;
    private int m_perms = 0;

    public int getID() {
        return this.m_id;
    }

    public boolean isGroupID() {
        return (Integer.MIN_VALUE & this.m_id) != 0;
    }

    public void setGranted(boolean bl) {
        if (bl) {
            this.m_flags |= 2;
            this.m_flags &= 0xFFFFFFFE;
        } else {
            this.m_flags |= 1;
            this.m_flags &= 0xFFFFFFFD;
        }
    }

    public boolean isGranted() {
        return (this.m_flags & 2) != 0;
    }

    public int getPermissionFlags() {
        return this.m_perms;
    }

    public void addPermission(int n) {
        this.m_perms |= n;
    }

    public void removePermission(int n) {
        this.m_perms &= ~n;
    }

    public boolean hasPermission(int n) {
        return (this.m_perms & n) != 0;
    }

    static AclEntry createFrom(ACE aCE) {
        AclEntry aclEntry = new AclEntry(aCE.m_id, true);
        aclEntry.m_flags = aCE.m_flags;
        aclEntry.m_id = aCE.m_id;
        aclEntry.m_perms = aCE.m_rights;
        return aclEntry;
    }

    ACE createRaw() {
        ACE aCE = new ACE(this.m_id, this.m_perms, this.m_flags);
        return aCE;
    }

    static AclEntry[] fromRaw(ACE[] aCEArray) {
        if (aCEArray == null) {
            return null;
        }
        int n = aCEArray.length;
        AclEntry[] aclEntryArray = new AclEntry[n];
        int n2 = 0;
        while (n2 < n) {
            aclEntryArray[n2] = AclEntry.createFrom(aCEArray[n2]);
            ++n2;
        }
        return aclEntryArray;
    }

    static ACE[] toRaw(AclEntry[] aclEntryArray) {
        if (aclEntryArray == null) {
            return null;
        }
        int n = aclEntryArray.length;
        ACE[] aCEArray = new ACE[n];
        int n2 = 0;
        while (n2 < n) {
            aCEArray[n2] = aclEntryArray[n2].createRaw();
            ++n2;
        }
        return aCEArray;
    }

    public AclEntry(int n, boolean bl) {
        this.m_id = n;
        this.m_flags = 0;
        this.m_flags |= bl ? 2 : 1;
        this.m_perms = 0;
    }
}

