/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.BasicCompare;
import com.starbase.diff.DiffCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.EditList;
import com.starbase.diff.HTMLDiffWriter;
import com.starbase.diff.HTMLTableDiffWriter;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.StarTeamDiff;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;

public class HTMLInterleavedDiffWriter
extends HTMLTableDiffWriter {
    private static final String HTML_ROW_HEADER = "<TR><TD rowSpan=2 nowrap class=\"CNVD\">&nbsp;{1}&nbsp;{2}&nbsp;</TD><TD nowrap class=\"CCHD\">&nbsp;</TD><TD colspan=3 nowrap width=\"90%\" class=\"CFN\"><SPAN class=\"HD\">&nbsp;{3}</SPAN></TD></TR>\r\n<TR><TD nowrap class=\"CCHD\">&nbsp;</TD><TD nowrap class=\"CLN\">&nbsp;</TD><TD colspan=2 nowrap class=\"CF2\"><SPAN class=\"HD\">&nbsp;{4}</SPAN></TD></TR>\r\n";
    private static final String HTML_ROW_FOOTER = "<TR><TD rowSpan=2 nowrap class=\"CNVD\">&nbsp;{1}&nbsp;{2}&nbsp;</TD><TD nowrap class=\"CCHD\">&nbsp;</TD><TD nowrap class=\"CLN\">&nbsp;</TD><TD colspan=2 nowrap class=\"CF2\"><SPAN class=\"HD\">&nbsp;{4}</SPAN></TD></TR>\r\n<TR><TD nowrap class=\"CCHD\">&nbsp;</TD><TD colspan=3 nowrap class=\"CFN\"><SPAN class=\"HD\">&nbsp;{3}</SPAN></TD></TR>\r\n";
    private static final String HTML_ROW_LINE_SAME = "<TR><TD class=\"CNV\">{0}</TD><TD class=\"CTU\">{1}</TD><TD {10}>{4}</TD><TD class=\"CL2\">{8}</TD><TD nowrap>&nbsp;{5}&nbsp;</TD></TR>\r\n";
    private static final String HTML_ROW_LINE_ADDED = "<TR><TD class=\"CNV\">{0}</TD><TD class=\"CTA\">{1}</TD><TD class=\"CLND\"></TD><TD class=\"CL2\">{8}</TD><TD nowrap class=\"CAD\">&nbsp;<SPAN class=\"add\">{9}</SPAN>&nbsp;</TD></TR>\r\n";
    private static final String HTML_ROW_LINE_DELETED = "<TR><TD class=\"CNV\">{0}</TD><TD class=\"CTD\">{1}</TD><TD class=\"CLN\">{4}</TD><TD class=\"CL2D\">&nbsp;</TD><TD nowrap class=\"CDL\">&nbsp;<SPAN class=\"del\">{5}</SPAN>&nbsp;</TD></TR>\r\n";
    private static final String HTML_ROW_LINE_REPLACED = "<TR><TD class=\"CNV\">{0}</TD><TD class=\"CTR\">{1}</TD><TD class=\"CLN\">{4}</TD><TD class=\"CL2\">{8}</TD><TD nowrap CRL>&nbsp;<SPAN {3}>{5}</SPAN>&nbsp;</TD></TR>\r\n";
    private static final String HTML_ROW_LINE_ELLIPSIS = "<TR><TD></TD><TD></TD><TD colspan=3><HR></TD></TR>\r\n";

    public static void diff(File file, File file2, File file3) throws FileNotFoundException, IOException, DiffException {
        int n = 25;
        HTMLInterleavedDiffWriter.diff(file, file2, n, file3);
    }

    public static void diff(File file, File file2, int n, File file3) throws FileNotFoundException, IOException, DiffException {
        BasicCompare basicCompare = new BasicCompare(n, null);
        HTMLInterleavedDiffWriter.diff(file, file2, basicCompare, file3);
    }

    public static void diff(File file, File file2, DiffCompare diffCompare, File file3) throws FileNotFoundException, IOException, DiffException {
        ParsedCharSequence parsedCharSequence = new ParsedCharSequence(file);
        ParsedCharSequence parsedCharSequence2 = new ParsedCharSequence(file2);
        StarTeamDiff starTeamDiff = new StarTeamDiff();
        EditList editList = starTeamDiff.diff(parsedCharSequence, parsedCharSequence2, diffCompare);
        HTMLInterleavedDiffWriter hTMLInterleavedDiffWriter = new HTMLInterleavedDiffWriter(parsedCharSequence, parsedCharSequence2, file3);
        hTMLInterleavedDiffWriter.write(editList, parsedCharSequence.size(), parsedCharSequence2.size());
    }

    protected String getRowHeaderHTML() {
        return HTML_ROW_HEADER;
    }

    protected String getRowFooterHTML() {
        return HTML_ROW_FOOTER;
    }

    protected String getRowBorderHTML() {
        return "";
    }

    protected String getHTMLRowLineSame() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_SAME);
    }

    protected String getHTMLRowLineAdded() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_ADDED);
    }

    protected String getHTMLRowLineDeleted() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_DELETED);
    }

    protected String getHTMLRowLineReplaced() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_REPLACED);
    }

    protected String getLeftReplaceText(HTMLDiffWriter.IntralineDiff intralineDiff) throws IOException {
        return intralineDiff.getCombinedMarkupText();
    }

    protected String getRightReplaceText(HTMLDiffWriter.IntralineDiff intralineDiff) throws IOException {
        return "";
    }

    protected String getHTMLRowEllipsis() {
        return HTML_ROW_LINE_ELLIPSIS;
    }

    public HTMLInterleavedDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, File file) throws IOException {
        super(parsedCharSequence, parsedCharSequence2, file);
    }

    public HTMLInterleavedDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, BufferedWriter bufferedWriter) {
        this(parsedCharSequence, parsedCharSequence2, (Writer)bufferedWriter);
    }

    public HTMLInterleavedDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, Writer writer) {
        super(parsedCharSequence, parsedCharSequence2, writer);
    }
}

