/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

public class Edit {
    public static final int UNCHANGED = 0;
    public static final int INSERT = 1;
    public static final int DELETE = 2;
    public static final int REPLACE = 3;
    private int m_eAction = 0;
    private int m_nStartSource = 0;
    private int m_nEndSource = 0;
    private int m_nStartTarget = 0;
    private int m_nEndTarget = 0;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(super.toString() + ": ");
        if (this.m_eAction == 1) {
            stringBuffer.append("insert: ");
        } else if (this.m_eAction == 2) {
            stringBuffer.append("delete: ");
        } else if (this.m_eAction == 3) {
            stringBuffer.append("replace: ");
        } else {
            stringBuffer.append("?: ");
        }
        stringBuffer.append("source=[" + this.m_nStartSource + ", " + this.m_nEndSource + "]");
        stringBuffer.append("; target=[" + this.m_nStartTarget + ", " + this.m_nEndTarget + "]");
        return stringBuffer.toString();
    }

    public int getAction() {
        return this.m_eAction;
    }

    public int startSource() {
        return this.m_nStartSource;
    }

    public int endSource() {
        return this.m_nEndSource;
    }

    public int startTarget() {
        return this.m_nStartTarget;
    }

    public int endTarget() {
        return this.m_nEndTarget;
    }

    public int getSourceChanges() {
        return this.m_nEndSource - this.m_nStartSource + 1;
    }

    public int getTargetChanges() {
        return this.m_nEndTarget - this.m_nStartTarget + 1;
    }

    public int getNumSourceChanges() {
        return this.m_nEndSource - this.m_nStartSource;
    }

    public int getNumTargetChanges() {
        return this.m_nEndTarget - this.m_nStartTarget;
    }

    public Edit(int n, int n2, int n3, int n4, int n5) {
        this.m_eAction = n;
        this.m_nStartSource = n2;
        this.m_nEndSource = n3;
        this.m_nStartTarget = n4;
        this.m_nEndTarget = n5;
    }
}

