/*
 * Decompiled with CFR 0.152.
 */
package com.borland.starteam.xml;

import com.borland.starteam.xml.XMLAttribute;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLElement {
    private static final String EMPTY = "";
    private static final String NS = ":";
    private static final XMLElement[] NO_CHILDREN = new XMLElement[0];
    private static final XMLAttribute[] NO_ATTRIBUTES = new XMLAttribute[0];
    private String m_name = null;
    private String m_fullname = null;
    private StringBuffer m_text = null;
    private Vector m_children = null;
    private Hashtable m_attributes = null;

    public String getName() {
        return this.m_name;
    }

    public String getQualifiedName() {
        return this.m_fullname;
    }

    public XMLElement[] getChildren() {
        if (this.m_children != null) {
            Object[] objectArray = new XMLElement[this.m_children.size()];
            this.m_children.copyInto(objectArray);
            return objectArray;
        }
        return NO_CHILDREN;
    }

    public XMLElement[] getChildren(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (this.m_children != null && string.indexOf(NS) < 0) {
            Object object;
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.m_children.elements();
            while (enumeration.hasMoreElements()) {
                object = (XMLElement)enumeration.nextElement();
                if (!((XMLElement)object).getQualifiedName().equals(string)) continue;
                vector.addElement(object);
            }
            object = new XMLElement[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return NO_CHILDREN;
    }

    public XMLElement getChild(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (this.m_children != null && string.indexOf(NS) < 0) {
            Enumeration enumeration = this.m_children.elements();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement = (XMLElement)enumeration.nextElement();
                if (!xMLElement.getName().equals(string)) continue;
                return xMLElement;
            }
        }
        return null;
    }

    public String getAttributeValue(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (this.m_attributes != null && string.indexOf(NS) < 0) {
            return (String)this.m_attributes.get(string);
        }
        return null;
    }

    public XMLAttribute[] getAttributes() {
        if (this.m_attributes != null) {
            int n = this.m_attributes.size();
            XMLAttribute[] xMLAttributeArray = new XMLAttribute[n];
            Enumeration enumeration = this.m_attributes.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.getAttributeValue(string);
                xMLAttributeArray[n2++] = new XMLAttribute(this, string, string2);
            }
            return xMLAttributeArray;
        }
        return NO_ATTRIBUTES;
    }

    public String getText() {
        if (this.m_text != null) {
            return this.m_text.toString();
        }
        return EMPTY;
    }

    void appendText(String string) {
        if (string == null) {
            Assert.nullArgument("String", "text");
        }
        if (this.m_text == null) {
            this.m_text = new StringBuffer();
        }
        this.m_text.append(string);
    }

    void addChild(XMLElement xMLElement) {
        if (xMLElement == null) {
            Assert.nullArgument("Element");
        }
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        this.m_children.addElement(xMLElement);
    }

    void setAttribute(String string, String string2) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (string2 == null) {
            Assert.nullArgument("String", "value");
        }
        if (this.m_attributes == null) {
            this.m_attributes = new Hashtable();
        }
        this.m_attributes.put(string, string2);
    }

    XMLElement(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        this.m_name = this.m_fullname = string;
        int n = this.m_name.lastIndexOf(NS);
        if (n >= 0) {
            this.m_name = this.m_name.substring(n + 1);
        }
    }
}

