/*
 * Decompiled with CFR 0.152.
 */
package com.borland.starteam.xml;

import com.borland.starteam.xml.XMLDocument;
import com.borland.starteam.xml.XMLElement;
import com.borland.starteam.xml.XMLException;
import com.borland.starteam.xml.XMLParseException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

class DOMBuilder {
    public XMLDocument build(InputStream inputStream) throws IOException, XMLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return this.build(document);
        }
        catch (SAXParseException sAXParseException) {
            throw new XMLParseException(sAXParseException, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new XMLException(exception);
        }
    }

    public XMLDocument build(Document document) {
        return new XMLDocument(document, this.build(document.getDocumentElement()));
    }

    public XMLElement build(Element element) {
        Node node;
        XMLElement xMLElement = new XMLElement(element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = namedNodeMap.item(n2);
            if (node2.getNodeType() == 2) {
                node = (Attr)node2;
                String string = node.getNodeName();
                String string2 = node.getValue();
                if (string != null && string2 != null) {
                    xMLElement.setAttribute(string, string2);
                }
            }
            ++n2;
        }
        NodeList nodeList = element.getChildNodes();
        n = nodeList.getLength();
        int n3 = 0;
        while (n3 < n) {
            node = nodeList.item(n3);
            short s = node.getNodeType();
            if (s == 1) {
                xMLElement.addChild(this.build((Element)node));
            } else if (s == 3 || s == 4) {
                xMLElement.appendText(node.getNodeValue());
            }
            ++n3;
        }
        return xMLElement;
    }

    DOMBuilder() {
    }
}

