#!/bin/bash

set -ue

pid=./clarity.pid
mem=-Xmx256m

JAR=`find ./ -name clarity*jar`
EXEC="java $mem -classpath .:$JAR ua.com.softway.tracker.startup.Main"

case $1 in
    start)
        $EXEC >out 2>err &
        echo $! >$pid
    ;;
    stop)
        kill `cat $pid`
        [ ! -z "`pgrep java`" ] && sleep 5 && kill -9 `cat $pid`
    ;;
    run)
	$EXEC
    ;;
    status)
        ps -ef | grep `cat $pid`
    ;;
    restart)
        $0 stop
        $0 start
    ;;
    *) echo "$0 [start|stop||run|status]" ;;
esac
