/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.worklog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ua.com.softway.tracker.worklog.Period;
import ua.com.softway.tracker.worklog.WorkLogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkLog {
    private final List<WorkLogItem> items = new ArrayList<WorkLogItem>();

    public void remove(String workLogItemKey) {
        Iterator<WorkLogItem> i = this.items.iterator();
        while (i.hasNext()) {
            if (!i.next().getKey().equals(workLogItemKey)) continue;
            i.remove();
        }
    }

    public Period getTimeSpent() {
        if (this.items.isEmpty()) {
            return null;
        }
        Period period = new Period("");
        for (WorkLogItem item : this.items) {
            period = period.sum(item.getPeriod());
        }
        return period;
    }

    public List<WorkLogItem> getItems() {
        return this.items;
    }

    public void add(WorkLogItem item) {
        this.items.add(item);
    }
}

