/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.worklog;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.worklog.Period;

public class TimeReportItem {
    final Issue issue;

    public TimeReportItem(Issue issue) {
        this.issue = issue;
    }

    public String getType() {
        return IssueField.TYPE.getHtmlValue(this.issue);
    }

    public String getKey() {
        return IssueField.KEY.getHtmlValue(this.issue);
    }

    public String getStatus() {
        return IssueField.STATUS.getHtmlValue(this.issue);
    }

    public String getPriority() {
        return IssueField.PRIORITY.getHtmlValue(this.issue);
    }

    public String getSummary() {
        return IssueField.SUMMARY.getHtmlValue(this.issue);
    }

    public String getOriginalEstimate() {
        if (this.issue.getEstimate() == null) {
            return "";
        }
        return this.issue.getEstimate().toLocalString();
    }

    public String getRemainingEstimate() {
        if (this.issue.getEstimate() == null) {
            return Resources.getText("timereport.na");
        }
        if (this.issue.getWorkLog().getTimeSpent() == null) {
            return this.issue.getEstimate().toLocalString();
        }
        if (this.issue.getEstimate().compareTo(this.issue.getWorkLog().getTimeSpent()) > 0) {
            return this.issue.getEstimate().difference(this.issue.getWorkLog().getTimeSpent()).toLocalString();
        }
        return "0";
    }

    public String getTimeSpent() {
        if (this.issue.getWorkLog().getTimeSpent() == null) {
            return "";
        }
        return this.issue.getWorkLog().getTimeSpent().toLocalString();
    }

    public String getAccuracy() {
        if (this.issue.getEstimate() == null || this.issue.getWorkLog().getTimeSpent() == null) {
            return Resources.getText("timereport.na");
        }
        return new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH)).format(this.getAccuracyValue()) + "%";
    }

    double getAccuracyValue() {
        Period delta = null;
        if (this.issue.getEstimate() == null || this.issue.getWorkLog().getTimeSpent() == null) {
            return Double.NaN;
        }
        delta = this.issue.getEstimate().compareTo(this.issue.getWorkLog().getTimeSpent()) > 0 ? this.issue.getEstimate().difference(this.issue.getWorkLog().getTimeSpent()) : this.issue.getWorkLog().getTimeSpent().difference(this.issue.getEstimate());
        return (double)delta.getMinutes() * 100.0 / (double)this.issue.getEstimate().getMinutes();
    }
}

