/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.worklog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.worklog.TimeReportItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class TimeReportAction {
    private final Tracker tracker;
    public String projectKey;
    public String versionKey;
    public String sortKey;
    public String filterKey;

    public TimeReportAction(Tracker tracker) {
        this.versionKey = SelectOption.NONE_OPTION.value;
        this.sortKey = Sort.Key.name().toLowerCase();
        this.filterKey = Filter.All.name().toLowerCase();
        this.tracker = tracker;
    }

    public String configure() {
        return "timereport/configure";
    }

    public List<SelectOption> getVersionOptions() {
        return SelectOptions.version(this.tracker.getProject(this.projectKey).getVersions(), true);
    }

    public String display() {
        return "timereport/timereport";
    }

    public List<TimeReportItem> getItems() {
        ArrayList<TimeReportItem> result = new ArrayList<TimeReportItem>();
        IssueMatcher matcher = new IssueMatcher(this.tracker, this.projectKey);
        if (!this.versionKey.equals(SelectOption.NONE_OPTION.value)) {
            matcher.setFix(this.versionKey);
        }
        if (this.filterKey.equals(Filter.Open.name())) {
            matcher.setStatuses(IssueStatus.openStatuses());
        }
        if (this.filterKey.equals(Filter.Resolved.name())) {
            matcher.setStatuses(IssueStatus.CLOSED, IssueStatus.RESOLVED);
        }
        for (Issue issue : matcher.getMatchedIssues()) {
            result.add(new TimeReportItem(issue));
        }
        Collections.sort(result, Sort.valueOf(this.sortKey));
        return result;
    }

    public List<SelectOption> getFilterOptions() {
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        for (Filter f : Filter.values()) {
            result.add(new SelectOption(f.name(), Resources.getText("timereport.filter." + f.name().toLowerCase())));
        }
        return result;
    }

    public List<SelectOption> getSortOptions() {
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        for (Sort f : Sort.values()) {
            result.add(new SelectOption(f.name(), Resources.getText("timereport.sort." + f.name().toLowerCase())));
        }
        return result;
    }

    public String getTitle() {
        Project project = this.tracker.getProject(this.projectKey);
        if (!this.versionKey.equals(SelectOption.NONE_OPTION.value)) {
            return Resources.getText("timereport.title.version", project.getName(), project.getVersion(this.versionKey).getName());
        }
        return Resources.getText("timereport.title", project.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Sort implements Comparator<TimeReportItem>
    {
        Key{

            public int compare(TimeReportItem o1, TimeReportItem o2) {
                return o1.issue.getKey().compareTo(o2.issue.getKey());
            }
        }
        ,
        Accuracy{

            public int compare(TimeReportItem o1, TimeReportItem o2) {
                return new Double(o1.getAccuracyValue()).compareTo(new Double(o2.getAccuracyValue()));
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Filter {
        Resolved,
        Open,
        All;

    }
}

