/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.worklog;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period
implements Comparable<Period> {
    private static final int DAYS_PER_WEEK = 5;
    private final String value;

    public Period(String value) {
        this.value = value;
    }

    public String toString() {
        return this.toExternalString();
    }

    public Period sum(Period e) {
        return Period.intern(0, 0, 0, this.getMinutes() + e.getMinutes()).normalize();
    }

    public Period difference(Period right) {
        return Period.intern(0, 0, 0, this.getMinutes() - right.getMinutes()).normalize();
    }

    Period normalize() {
        return Period.intern(this.getWeeks(), this.getDays() % 5, this.getHours() % 24, this.getMinutes() % 60);
    }

    int getMinutes() {
        int minutes = 0;
        StringTokenizer tokenizer = new StringTokenizer(this.value);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            minutes += this.toMinutes(token);
        }
        return minutes;
    }

    int getHours() {
        return this.getMinutes() / 60;
    }

    int getDays() {
        return this.getHours() / 24;
    }

    int getWeeks() {
        return this.getDays() / 5;
    }

    static Period intern(int weeks, int days, int hours, int minutes) {
        StringBuffer result = new StringBuffer();
        if (weeks > 0) {
            result.append(weeks + "w ");
        }
        if (days > 0) {
            result.append(days + "d ");
        }
        if (hours > 0) {
            result.append(hours + "h ");
        }
        if (minutes > 0) {
            result.append(minutes + "m ");
        }
        return new Period(result.toString().trim());
    }

    private int toMinutes(String token) {
        int value;
        try {
            value = new DecimalFormat().parse(token).intValue();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (token.endsWith("w")) {
            return value * 60 * 24 * 5;
        }
        if (token.endsWith("d")) {
            return value * 60 * 24;
        }
        if (token.endsWith("h")) {
            return value * 60;
        }
        return value;
    }

    public String toLocalString() {
        return this.toString();
    }

    public static Period fromLocalString(String estimate) {
        for (char c : estimate.toCharArray()) {
            if (c == 'w' || c == 'd' || c == 'h' || c == 'm' || c == ' ' || c >= '0' && c <= '9') continue;
            return null;
        }
        return new Period(estimate);
    }

    public String toExternalString() {
        return this.value;
    }

    public static Period fromExternalString(String s) {
        return new Period(s);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Period other = (Period)obj;
        return this.value.equals(other.value);
    }

    @Override
    public int compareTo(Period period) {
        return this.getMinutes() - period.getMinutes();
    }
}

