/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup.list;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.wiki.markup.list.ListItem;
import ua.com.softway.tracker.wiki.markup.list.ListType;
import ua.com.softway.tracker.wiki.markup.list.Renderable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserList
implements Renderable {
    private ListType type;
    private List<String> items;

    public UserList(ListType type, List<String> lines) {
        this.type = type;
        this.items = lines;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public String render() {
        ArrayList<ListItem> renderables = new ArrayList<ListItem>();
        ListType listType = null;
        ArrayList<String> lines = new ArrayList<String>();
        for (String item : this.items) {
            if (ListType.parse(item) != listType) {
                if (listType == null) {
                    for (int i = 0; i < lines.size() - 1; ++i) {
                        String line = (String)lines.get(i);
                        renderables.add(new ListItem(line));
                    }
                    if (lines.size() > 0) {
                        String last = (String)lines.get(lines.size() - 1);
                        lines = new ArrayList();
                        lines.add(last);
                    } else {
                        lines.add("");
                    }
                } else {
                    renderables.add(new ListItem((String)lines.get(0), new UserList(listType, lines.subList(1, lines.size()))));
                    lines = new ArrayList();
                }
                listType = ListType.parse(item);
            }
            lines.add(ListType.trimFirstMarker(item));
        }
        if (listType == null) {
            for (String line : lines) {
                renderables.add(new ListItem(line));
            }
        } else {
            renderables.add(new ListItem((String)lines.get(0), new UserList(listType, lines.subList(1, lines.size()))));
        }
        StringBuilder result = new StringBuilder();
        if (this.type == ListType.ORDERER) {
            result.append("<ol class='wiki'>");
        } else {
            result.append("<ul class='wiki'>");
        }
        for (Renderable renderable : renderables) {
            result.append(renderable.render());
        }
        if (this.type == ListType.ORDERER) {
            result.append("</ol>");
        } else {
            result.append("</ul>");
        }
        return result.toString();
    }
}

