/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup.list;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import ua.com.softway.tracker.wiki.markup.MarkupRule;
import ua.com.softway.tracker.wiki.markup.list.ListType;
import ua.com.softway.tracker.wiki.markup.list.Renderable;
import ua.com.softway.tracker.wiki.markup.list.TextLines;
import ua.com.softway.tracker.wiki.markup.list.UserList;

public class ListRule
implements MarkupRule {
    public String apply(String text) {
        LineNumberReader reader = new LineNumberReader(new StringReader(text));
        ArrayList<Renderable> rendereables = new ArrayList<Renderable>();
        ListType listType = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ListType currentListType = ListType.parse(line);
                if (currentListType != listType) {
                    if (listType == null) {
                        rendereables.add(new TextLines(lines));
                    } else {
                        rendereables.add(new UserList(listType, lines));
                    }
                    listType = currentListType;
                    lines = new ArrayList();
                }
                lines.add(ListType.trimFirstMarker(line));
            }
            if (listType == null) {
                rendereables.add(new TextLines(lines));
            } else {
                rendereables.add(new UserList(listType, lines));
            }
        }
        catch (IOException imposible) {
            // empty catch block
        }
        StringBuilder result = new StringBuilder();
        for (Renderable rendereable : rendereables) {
            result.append(rendereable.render());
        }
        return result.toString();
    }
}

