/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.wiki.markup.HtmlReplaceRule;
import ua.com.softway.tracker.wiki.markup.HtmlWrapRule;
import ua.com.softway.tracker.wiki.markup.MarkupRule;
import ua.com.softway.tracker.wiki.markup.NowikiRules;
import ua.com.softway.tracker.wiki.markup.PageLinkRule;
import ua.com.softway.tracker.wiki.markup.TableRule;
import ua.com.softway.tracker.wiki.markup.XmlEscapeRule;
import ua.com.softway.tracker.wiki.markup.list.ListRule;

public class WikiMarkupRules
implements MarkupRule {
    private List<MarkupRule> rules = new ArrayList<MarkupRule>();

    public WikiMarkupRules() {
        NowikiRules nowikiRules = new NowikiRules();
        this.rules.add(nowikiRules.hideContent());
        this.rules.add(new XmlEscapeRule());
        this.rules.add(new ListRule());
        this.rules.add(new TableRule());
        this.rules.add(new HtmlReplaceRule("----", "<hr/>"));
        this.rules.add(new HtmlReplaceRule("\n", "<br/>"));
        this.rules.add(new HtmlWrapRule("===", "===", "<h3 class='wiki'>", "</h3>"));
        this.rules.add(new HtmlWrapRule("==", "==", "<h2 class='wiki'>", "</h2>"));
        this.rules.add(new HtmlWrapRule("**", "**", "<b>", "</b>"));
        this.rules.add(new HtmlWrapRule("//", "//", "<i>", "</i>"));
        this.rules.add(new HtmlWrapRule("^^", "^^", "<sup>", "</sup>"));
        this.rules.add(new HtmlWrapRule("__", "__", "<sub>", "</sub>"));
        this.rules.add(new HtmlWrapRule("-/", "/-", "<strike>", "</strike>"));
        this.rules.add(new PageLinkRule());
        this.rules.add(nowikiRules.showContent());
    }

    public String apply(String markup) {
        if (markup == null) {
            return "";
        }
        String html = markup;
        for (MarkupRule rule : this.rules) {
            html = rule.apply(html);
        }
        return "<span class='wiki_markup'>" + html + "</span>";
    }
}

