/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import ua.com.softway.tracker.wiki.markup.MarkupRule;

public class TableRule
implements MarkupRule {
    public String apply(String text) {
        LineNumberReader reader = new LineNumberReader(new StringReader(text));
        StringBuilder result = new StringBuilder();
        boolean inTable = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (TableRule.isRow(line)) {
                    if (!inTable) {
                        result.append("<table class='wiki' cellpadding='0' cellspacing='0'>");
                        inTable = true;
                    }
                    this.processRow(line, result);
                    continue;
                }
                if (inTable) {
                    result.append("</table>");
                    inTable = false;
                }
                result.append(line + "\n");
            }
        }
        catch (IOException imposible) {
            // empty catch block
        }
        if (inTable) {
            result.append("</table>");
        }
        return result.toString();
    }

    private void processRow(String line, StringBuilder target) {
        if (!TableRule.isRow(line)) {
            target.append(line);
        }
        target.append("<tr>");
        String[] columns = line.split("\\|");
        for (int i = 1; i < columns.length; ++i) {
            String column = columns[i];
            target.append("<td class='wiki'>").append(column).append("</td>");
        }
        target.append("</tr>");
    }

    private static boolean isRow(String line) {
        for (char c : line.toCharArray()) {
            if (c == '|') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return false;
    }
}

