/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup;

import ua.com.softway.tracker.wiki.Page;
import ua.com.softway.tracker.wiki.Wiki;
import ua.com.softway.tracker.wiki.action.WikiPages;
import ua.com.softway.tracker.wiki.markup.BlockTagRule;

public class PageLinkRule
extends BlockTagRule {
    public PageLinkRule() {
        super("[[", "]]", true);
    }

    protected String renderTag(String tagContent) {
        String href;
        String label;
        String link;
        if (tagContent.indexOf(124) == -1) {
            link = tagContent;
            label = null;
        } else {
            int separatorIndex = tagContent.indexOf(124);
            label = tagContent.substring(0, separatorIndex);
            link = tagContent.substring(separatorIndex + 1, tagContent.length());
        }
        if (link.startsWith("http://")) {
            href = link;
            if (label == null) {
                label = link;
            }
        } else {
            Page page = Wiki.instance().getPage(tagContent);
            if (page != null) {
                href = WikiPages.viewPage(page.getKey()).getPath();
                if (label == null) {
                    label = page.getName();
                }
            } else {
                href = null;
            }
        }
        if (href == null) {
            return this.wikiTagStart + tagContent + this.wikiTagEnd;
        }
        return "<a class='wiki' href='" + href + "'/>" + label + "</a>";
    }
}

