/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.util.XmlEscaper;
import ua.com.softway.tracker.wiki.markup.BlockTagRule;
import ua.com.softway.tracker.wiki.markup.MarkupRule;

public class NowikiRules {
    private List<String> hiddenContent = new ArrayList<String>();
    private static final String NOWIKI_START = "NowikiStart";
    private static final String NOWIKI_END = "NowikiEnd";

    public MarkupRule hideContent() {
        return new BlockTagRule("<nowiki>", "</nowiki>", false){

            protected String renderTag(String tagContent) {
                NowikiRules.this.hiddenContent.add(tagContent);
                return NowikiRules.NOWIKI_START + (NowikiRules.this.hiddenContent.size() - 1) + NowikiRules.NOWIKI_END;
            }
        };
    }

    public MarkupRule showContent() {
        return new BlockTagRule(NOWIKI_START, NOWIKI_END, false){

            protected String renderTag(String tagContent) {
                int contentIndex = Integer.parseInt(tagContent);
                String content = (String)NowikiRules.this.hiddenContent.get(contentIndex);
                return XmlEscaper.escape(content);
            }
        };
    }
}

