/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.markup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import ua.com.softway.tracker.wiki.markup.MarkupRule;

public abstract class BlockTagRule
implements MarkupRule {
    protected String wikiTagStart;
    protected String wikiTagEnd;
    private boolean lineByLine;

    protected BlockTagRule(String startMarker, String endMarker, boolean lineByLine) {
        this.wikiTagStart = startMarker;
        this.wikiTagEnd = endMarker;
        this.lineByLine = lineByLine;
    }

    public String apply(String text) {
        if (!this.lineByLine) {
            return this.processTag(text);
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String result = "";
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result = result + this.processTag(line) + "\n";
            }
        }
        catch (IOException imposible) {
            // empty catch block
        }
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String processTag(String text) {
        int endIndex;
        int startIndex;
        String result = "";
        int scanFrom = 0;
        while ((startIndex = text.indexOf(this.wikiTagStart, scanFrom)) != -1 && (endIndex = text.indexOf(this.wikiTagEnd, startIndex + this.wikiTagStart.length())) != -1) {
            String beforeTag = text.substring(scanFrom, startIndex);
            String tagContent = text.substring(startIndex + this.wikiTagStart.length(), endIndex);
            result = result + beforeTag + this.renderTag(tagContent);
            scanFrom = endIndex + this.wikiTagEnd.length();
        }
        result = result + text.substring(scanFrom, text.length());
        return result;
    }

    protected abstract String renderTag(String var1);
}

