/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.action.page;

import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;
import ua.com.softway.tracker.wiki.Page;
import ua.com.softway.tracker.wiki.WikiFolder;
import ua.com.softway.tracker.wiki.action.page.PageId2WikiWordRule;
import ua.com.softway.tracker.wiki.action.page.WikiWord2PageIdRule;
import ua.com.softway.tracker.wiki.markup.WikiMarkupRules;

public class PageForm {
    public String wikiFolderKey = "";
    public String pageKey = "";
    public String name = "";
    public String markup = "";

    public void copyFrom(Page page) {
        this.wikiFolderKey = page.getKey().getWikiFolderKey();
        this.pageKey = page.getKey().value();
        this.name = page.getName();
        this.markup = new PageId2WikiWordRule().apply(page.getMarkup());
    }

    public void copyTo(Page page) {
        page.setName(this.name);
        page.setMarkup(new WikiWord2PageIdRule().apply(this.markup));
    }

    public boolean isEditing() {
        return !Strings.isBlank(this.pageKey);
    }

    public boolean valid(Messages messages, WikiFolder wikiFolder) {
        if (Strings.isBlank(this.name)) {
            messages.addMessage("pages.error.name.required", new Object[0]);
        }
        this.checkDuplicateName(messages, wikiFolder);
        return messages.isEmpty();
    }

    private void checkDuplicateName(Messages messages, WikiFolder wikiFolder) {
        if (!this.isEditing()) {
            if (wikiFolder.getPageWithName(this.name) != null) {
                messages.addMessage("pages.error.duplicate.name", this.name);
            }
            return;
        }
        String oldPageName = wikiFolder.getPage(this.pageKey).getName();
        if (!oldPageName.equals(this.name) && wikiFolder.getPageWithName(this.name) != null) {
            messages.addMessage("pages.error.duplicate.name", this.name);
        }
    }

    public String getHtml() {
        return new WikiMarkupRules().apply(this.markup);
    }
}

