/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.action;

import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;
import ua.com.softway.tracker.wiki.Wiki;
import ua.com.softway.tracker.wiki.WikiFolder;
import ua.com.softway.tracker.wiki.action.NoSuchWikiFolder;
import ua.com.softway.tracker.wiki.action.WikiPages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker/admin")
public class WikiFolderAction {
    public boolean editing = false;
    public String key = "";
    public String name = "";
    public Messages messages = new Messages();
    private Wiki wiki = Wiki.instance();

    public String list() {
        return "wiki/wikiFolders";
    }

    public List<WikiFolder> getWikiFolders() {
        return this.wiki.getWikiFolders();
    }

    public String editWikiFolder() {
        WikiFolder wikiFolder = this.wiki.getWikiFolder(this.key);
        if (wikiFolder != null) {
            this.editing = true;
            this.name = wikiFolder.getName();
        }
        return "wiki/editWikiFolder";
    }

    public Object storeWikiFolder() {
        if (!this.editing) {
            if (Strings.isBlank(this.key)) {
                this.messages.addMessage("wikiFolders.key.required", new Object[0]);
            } else if (!Strings.isLatinLetter(this.key) || !this.key.equals(this.key.toUpperCase())) {
                this.messages.addMessage("wikiFolders.key.invalid.letters", new Object[0]);
            }
            if (this.wiki.getWikiFolder(this.key) != null) {
                this.messages.addMessage("wikiFolders.key.duplicate", new Object[0]);
            }
        }
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("wikiFolders.name.required", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "wiki/editWikiFolder";
        }
        WikiFolder wikiFolder = this.wiki.getWikiFolder(this.key);
        if (wikiFolder == null) {
            wikiFolder = this.wiki.addWikiFolder(this.key);
        }
        wikiFolder.setName(this.name);
        wikiFolder.store();
        return WikiPages.manageWikiFolders();
    }

    public Object deleteWikiFolder() {
        WikiFolder wikiFolder = this.wiki.getWikiFolder(this.key);
        if (wikiFolder == null) {
            return new NoSuchWikiFolder(this.key);
        }
        this.wiki.deleteWikiFolder(wikiFolder);
        return WikiPages.manageWikiFolders();
    }
}

