/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ua.com.softway.tracker.wiki.Page;
import ua.com.softway.tracker.wiki.PageKey;
import ua.com.softway.tracker.wiki.Wiki;
import ua.com.softway.tracker.wiki.action.WikiPages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageHistory {
    public static final int CAPACITY = 5;
    private LinkedList<String> pages = new LinkedList();

    public void pageViewed(String pageKey) {
        String last = null;
        if (!this.pages.isEmpty()) {
            last = this.pages.getLast();
        }
        if (!pageKey.equals(last)) {
            this.pages.addLast(pageKey);
        }
        if (this.pages.size() > 5) {
            this.pages.removeFirst();
        }
    }

    public List<ViewedPage> getViewedPages() {
        ArrayList<ViewedPage> pages = new ArrayList<ViewedPage>();
        for (String pageKey : this.pages) {
            pages.add(new ViewedPage(pageKey));
        }
        return pages;
    }

    public List<ViewedPage> getViewedPagesReversed() {
        List<ViewedPage> viewedPages = this.getViewedPages();
        Collections.reverse(viewedPages);
        return viewedPages;
    }

    public String getLastViewedExistingPageKey() {
        while (!this.pages.isEmpty() && Wiki.instance().getPage(this.pages.getLast()) == null) {
            this.pages.removeLast();
        }
        if (this.pages.isEmpty()) {
            return null;
        }
        return this.pages.getLast();
    }

    public static class ViewedPage {
        private String pageKey;

        public ViewedPage(String pageKey) {
            this.pageKey = pageKey;
        }

        public String getName() {
            Page page = Wiki.instance().getPage(this.pageKey);
            if (page == null) {
                return this.pageKey;
            }
            return page.getName();
        }

        public boolean isDeleted() {
            return Wiki.instance().getPage(this.pageKey) == null;
        }

        public String getUrl() {
            if (this.isDeleted()) {
                return null;
            }
            return WikiPages.viewPage(PageKey.valueOf(this.pageKey)).getPath();
        }
    }
}

