/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.storage.ObjectDirectory;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.wiki.Page;
import ua.com.softway.tracker.wiki.PageKey;
import ua.com.softway.tracker.wiki.PageSerializer;
import ua.com.softway.tracker.wiki.WikiFolders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiFolder {
    private String key;
    private ObjectUpdater<WikiFolder> updater;
    private String name;
    private ObjectDirectory<Page> pageDirectory;

    public WikiFolder(String key, ObjectUpdater<WikiFolder> updater) {
        this.key = key;
        this.updater = updater;
        Folder pagesFolder = WikiFolders.getPageFolder(this);
        this.pageDirectory = new ObjectDirectory<Page>(new PageSerializer(), pagesFolder);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Page> getPages() {
        return new ArrayList<Page>(this.pageDirectory.getObjects().values());
    }

    public Page getPage(String key) {
        return this.pageDirectory.getObjects().get(key);
    }

    public Page addPage() {
        PageKey pageKey = new PageKey(this.key, this.nextPageIndex());
        return new Page(pageKey, this.pageDirectory);
    }

    private int nextPageIndex() {
        int maxPageIndex = -1;
        for (Page page : this.getPages()) {
            if (page.getKey().getPageIndex() <= maxPageIndex) continue;
            maxPageIndex = page.getKey().getPageIndex();
        }
        return maxPageIndex + 1;
    }

    public void deletePage(Page page) {
        this.pageDirectory.delete(page.getKey().value());
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WikiFolder)) {
            return false;
        }
        WikiFolder that = (WikiFolder)obj;
        return that.key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "WikiFolder{" + this.key + "}";
    }

    public Page getPageWithName(String name) {
        for (Page page : this.getPages()) {
            if (!page.getName().equals(name)) continue;
            return page;
        }
        return null;
    }
}

