/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import ua.com.softway.tracker.util.StreamPump;
import ua.com.softway.tracker.wiki.markup.WikiMarkupRules;

public class WikiFileRenderer {
    private String file;

    public WikiFileRenderer(String file) {
        this.file = file;
        if (this.getClass().getResourceAsStream(file) == null) {
            throw new IllegalArgumentException("no such file: " + file);
        }
    }

    public String render() {
        InputStream inputStream = this.getClass().getResourceAsStream(this.file);
        StringWriter stringWriter = new StringWriter();
        try {
            StreamPump.pumpAndClose(new InputStreamReader(inputStream, "UTF-8"), stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new WikiMarkupRules().apply(stringWriter.getBuffer().toString());
    }
}

