/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.storage.ObjectDirectory;
import ua.com.softway.tracker.wiki.Page;
import ua.com.softway.tracker.wiki.WikiFolder;
import ua.com.softway.tracker.wiki.WikiFolderSerializer;
import ua.com.softway.tracker.wiki.WikiFolders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wiki {
    private ObjectDirectory<WikiFolder> wikiFolders;
    private static Wiki instance;

    public static Wiki configure(Folder dataFolder) {
        WikiFolders.setDataFolder(dataFolder);
        instance = new Wiki();
        return instance;
    }

    public static Wiki instance() {
        if (instance == null) {
            throw new IllegalStateException("wiki is not cofigured (call configure())");
        }
        return instance;
    }

    private Wiki() {
        Folder wikiFolderFolder = WikiFolders.getWikiFolderFolder();
        this.wikiFolders = new ObjectDirectory<WikiFolder>(new WikiFolderSerializer(), wikiFolderFolder);
    }

    public List<WikiFolder> getWikiFolders() {
        return new ArrayList<WikiFolder>(this.wikiFolders.getObjects().values());
    }

    public WikiFolder getWikiFolder(String key) {
        for (WikiFolder wikiFolder : this.getWikiFolders()) {
            if (!wikiFolder.getKey().equals(key)) continue;
            return wikiFolder;
        }
        return null;
    }

    public WikiFolder addWikiFolder(String key) {
        if (this.getWikiFolder(key) != null) {
            throw new IllegalArgumentException("wikiFolder with key " + key + " already exists");
        }
        WikiFolder wikiFolder = new WikiFolder(key, this.wikiFolders);
        return wikiFolder;
    }

    public void deleteWikiFolder(WikiFolder wikiFolder) {
        this.wikiFolders.delete(wikiFolder.getKey());
    }

    public Page getPage(String key) {
        for (WikiFolder wikiFolder : this.getWikiFolders()) {
            if (wikiFolder.getPage(key) == null) continue;
            return wikiFolder.getPage(key);
        }
        return null;
    }
}

