/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.wiki;

public class PageKey {
    private String wikiFolderKey;
    private int pageIndex;

    public static PageKey valueOf(String pageKey) {
        if (pageKey == null) {
            throw new IllegalArgumentException("pageKey is null");
        }
        String[] parts = pageKey.split("-");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid pageKey " + pageKey);
        }
        try {
            int pageIndex = Integer.parseInt(parts[1]);
            return new PageKey(parts[0], pageIndex);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid pageKey " + pageKey);
        }
    }

    public PageKey(String wikiFolderKey, int pageIndex) {
        if (wikiFolderKey == null) {
            throw new IllegalArgumentException("wikiFolderKey is null");
        }
        this.wikiFolderKey = wikiFolderKey;
        this.pageIndex = pageIndex;
    }

    public String getWikiFolderKey() {
        return this.wikiFolderKey;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageKey)) {
            return false;
        }
        PageKey that = (PageKey)obj;
        return that.wikiFolderKey.equals(this.wikiFolderKey) && that.pageIndex == this.pageIndex;
    }

    public int hashCode() {
        return this.wikiFolderKey.hashCode() + this.pageIndex;
    }

    public String value() {
        return this.wikiFolderKey + "-" + this.pageIndex;
    }

    public String toString() {
        return "PageKey{" + this.value() + "}";
    }
}

