/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.velocity;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lime.executor.OutcomeHandler;
import ua.com.softway.tracker.DateFormat;
import ua.com.softway.tracker.TrackerVersion;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.issue.CurrentProject;
import ua.com.softway.tracker.action.issue.IssueFilterForm;
import ua.com.softway.tracker.configuration.Configurator;
import ua.com.softway.tracker.configuration.TrackerConfiguration;
import ua.com.softway.tracker.startup.HtmlContextPrepender;
import ua.com.softway.tracker.startup.SessionObject;
import ua.com.softway.tracker.util.XmlEscaper;
import ua.com.softway.tracker.velocity.VelocityTemplate;
import ua.com.softway.tracker.wiki.action.PageHistory;
import ua.com.softway.tracker.wiki.action.WikiPages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityHandler
implements OutcomeHandler {
    @Override
    public boolean handle(Object action, Object outcome, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!(outcome instanceof String)) {
            return false;
        }
        String path = outcome + ".vm";
        VelocityTemplate template = new VelocityTemplate(path);
        template.putAll(this.getContext(action, request));
        StringWriter stringWriter = new StringWriter();
        template.render(stringWriter);
        HtmlContextPrepender contextPrepender = new HtmlContextPrepender(request.getContextPath());
        response.setContentType("text/html;charset=UTF-8");
        contextPrepender.filter(stringWriter.toString(), response.getWriter());
        return true;
    }

    private Map<String, Object> getContext(Object action, HttpServletRequest request) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("action", action);
        DateFormat dateFormat = User.currentUser() == null ? new DateFormat() : User.currentUser().getDateFormat();
        context.put("dateFormat", dateFormat);
        context.put("pages", new Pages());
        context.put("wikiPages", new WikiPages());
        context.put("pageHistory", SessionObject.get(request, PageHistory.class));
        CurrentProject currentProject = SessionObject.get(request, IssueFilterForm.class);
        if (currentProject != null) {
            context.put("currentProject", currentProject.getCurrentProject());
        }
        if (User.currentUser() != null) {
            context.put("currentUser", User.currentUser());
        }
        context.put("version", TrackerVersion.getVersion());
        context.put("escaper", new XmlEscaper());
        TrackerConfiguration configuration = Configurator.getConfiguration();
        if (configuration.isConfigured()) {
            context.put("registrationKey", configuration.getLicenseKey());
        }
        return context;
    }
}

