/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.FileSystemException;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.util.StreamPump;

public class ZipArchiver {
    public static void pack(Folder folder, File targetFile) {
        ZipOutputStream zipOutputStream = new ZipOutputStream(targetFile.openOutputStream());
        try {
            for (File file : folder.getFiles()) {
                ZipArchiver.addFile(zipOutputStream, file, "");
            }
            for (Folder subFolder : folder.getFolders()) {
                ZipArchiver.addFolder(zipOutputStream, subFolder, "");
            }
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (IOException e) {}
        }
    }

    private static void addFolder(ZipOutputStream zipOutputStream, Folder folder, String pathPrefix) throws IOException {
        if (folder.getFiles().isEmpty() && folder.getFolders().isEmpty()) {
            zipOutputStream.putNextEntry(new ZipEntry(pathPrefix + folder.getName() + "/"));
        }
        for (File file : folder.getFiles()) {
            ZipArchiver.addFile(zipOutputStream, file, pathPrefix + folder.getName() + "/");
        }
        for (Folder subFolder : folder.getFolders()) {
            ZipArchiver.addFolder(zipOutputStream, subFolder, pathPrefix + folder.getName() + "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(ZipOutputStream zipOutputStream, File file, String pathPrefix) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(pathPrefix + file.getName()));
        InputStream fileInputStream = file.openInputStream();
        try {
            StreamPump.pump(fileInputStream, zipOutputStream);
        }
        finally {
            fileInputStream.close();
        }
    }
}

