/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.util;

import ua.com.softway.tracker.util.InvalidIssueKeyException;

public class IssueKey {
    private String projectKey;
    private int issueIndex;

    public IssueKey(String issueKey) throws InvalidIssueKeyException {
        String[] parts = issueKey.split("-");
        if (parts.length != 2) {
            throw new InvalidIssueKeyException(issueKey);
        }
        if (parts[0].length() == 0 || parts[1].length() == 0) {
            throw new InvalidIssueKeyException(issueKey);
        }
        this.projectKey = parts[0];
        try {
            this.issueIndex = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidIssueKeyException(issueKey);
        }
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public int getIssueIndex() {
        return this.issueIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueKey issueKey = (IssueKey)o;
        if (this.issueIndex != issueKey.issueIndex) {
            return false;
        }
        return this.projectKey.equals(issueKey.projectKey);
    }

    public int hashCode() {
        int result = this.projectKey.hashCode();
        result = 29 * result + this.issueIndex;
        return result;
    }

    public String toString() {
        return "IssueKey{" + this.projectKey + "-" + this.issueIndex + "}";
    }
}

