/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class CsvWriter {
    private PrintWriter writer;
    private static Set<Character> badCharacters = new HashSet<Character>();

    public CsvWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void writeColumn(String value) {
        boolean containsBadChar = false;
        for (Character badCharacter : badCharacters) {
            if (!value.contains("" + badCharacter)) continue;
            containsBadChar = true;
        }
        if (!containsBadChar) {
            this.writer.write(value);
        } else {
            this.writer.write(34);
            this.writer.write(value.replace("\"", "\"\""));
            this.writer.write(34);
        }
        this.writeDelimiter();
        this.writer.flush();
    }

    public void nextRow() {
        this.writer.println();
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
        if (this.writer.checkError()) {
            throw new RuntimeException("trouble during closing writer " + this.writer);
        }
    }

    private void writeDelimiter() {
        this.writer.write(44);
    }

    static {
        badCharacters.add(Character.valueOf(','));
        badCharacters.add(Character.valueOf('\"'));
        badCharacters.add(Character.valueOf('\n'));
        badCharacters.add(Character.valueOf('\r'));
    }
}

