/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.util.ZipArchiver;

public class Backup {
    private Folder backupFolder;
    private Folder dataFolder;
    private static final long ONE_DAY = 86400000L;
    private Timer timer = new Timer("backup", true);

    public Backup(Folder backupFolder, Folder dataFolder) {
        this.backupFolder = backupFolder;
        this.dataFolder = dataFolder;
    }

    public void start() {
        this.timer.scheduleAtFixedRate((TimerTask)new BackupTask(), this.tomorrowMidnight(), 86400000L);
    }

    private Date tomorrowMidnight() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private class BackupTask
    extends TimerTask {
        private BackupTask() {
        }

        public void run() {
            String timeStamp = new SimpleDateFormat("dd-MM-yyyy-HH-mm").format(new Date());
            File backupFile = Backup.this.backupFolder.getFile("tracker-backup-" + timeStamp + ".zip");
            System.out.println("Creating backup ... ");
            ZipArchiver.pack(Backup.this.dataFolder, backupFile);
            System.out.println("Backup done");
        }
    }
}

