/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.text.TextRenderer;

public class IssueLinkRenderer
implements TextRenderer {
    private final String viewIssueUrl;

    public IssueLinkRenderer(String viewIssueUrl) {
        this.viewIssueUrl = viewIssueUrl;
    }

    public String render(String text) {
        if (text == null) {
            return "";
        }
        String url = Matcher.quoteReplacement(this.viewIssueUrl);
        Pattern pattern = Pattern.compile("\\b([A-Za-z]+-[0-9]+)\\b", 2);
        Matcher matcher = pattern.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String issueKey = this.getUppercasedIssueKey(matcher.group(1));
            Issue issue = Tracker.instance().getIssue(issueKey);
            if (issue == null) {
                matcher.appendReplacement(result, "$0");
                continue;
            }
            if (IssueStatus.RESOLVED.equals(issue.getStatus()) || IssueStatus.CLOSED.equals(issue.getStatus())) {
                matcher.appendReplacement(result, "<a href='" + url + issueKey + "'><strike>" + issueKey + "</strike></a>");
                continue;
            }
            matcher.appendReplacement(result, "<a href='" + url + issueKey + "'>" + issueKey + "</a>");
        }
        matcher.appendTail(result);
        if (result.length() > 0) {
            return result.toString();
        }
        return text;
    }

    private String getUppercasedIssueKey(String key) {
        return key.toUpperCase();
    }
}

