/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.storage;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.FileSystemException;
import ua.com.softway.tracker.storage.Properties;

public class Xml {
    public static Properties load(File file) {
        XmlParse p = new XmlParse();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            Reader reader = file.openReader();
            parser.parse(new InputSource(reader), (DefaultHandler)p);
            reader.close();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException("error parsing file: " + String.valueOf(file), e);
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        return p.getProperties();
    }

    public static void save(File file, String rootElement, Properties props) {
        try {
            Writer writer = file.openWriter();
            props.write(rootElement, writer, 0);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    private static class XmlParse
    extends DefaultHandler {
        private List<State> stack = new ArrayList<State>();

        private XmlParse() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            State i = new State();
            i.type = attributes.getValue("type");
            this.stack.add(0, i);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stack.get((int)0).buffer.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.stack.size() > 1) {
                State current = this.stack.get(0);
                State parent = this.stack.get(1);
                if ("list".equals(current.type)) {
                    parent.properties.addList(qName, "elementName", current.propertiesList);
                } else if ("item".equals(current.type)) {
                    parent.propertiesList.add(current.properties);
                } else {
                    parent.properties.addProperty(qName, current.buffer.toString().trim());
                }
                this.stack.remove(0);
            }
        }

        public Properties getProperties() {
            return this.stack.get((int)0).properties;
        }
    }

    private static class State {
        public List<Properties> propertiesList = new ArrayList<Properties>();
        public Properties properties = new Properties();
        public StringBuffer buffer = new StringBuffer();
        public String type;

        private State() {
        }
    }
}

