/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.storage;

import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;
import ua.com.softway.tracker.storage.Xml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleObjectStore<T>
implements ObjectUpdater<T> {
    private final Serializer<T> serializer;
    private final File file;
    private T object;

    public SingleObjectStore(Serializer<T> serializer, File file) {
        this.serializer = serializer;
        this.file = file;
        if (file.exists()) {
            this.load();
        }
    }

    private void load() {
        Properties properties = Xml.load(this.file);
        this.object = this.serializer.load(this, properties, this.file.getName());
    }

    @Override
    public void saveOrUpdate(T object) {
        String key = this.serializer.getKey(object);
        this.saveObject(key, object);
        this.object = object;
    }

    private void saveObject(String key, T object) {
        Properties properties = new Properties();
        this.serializer.save(properties, object);
        Xml.save(this.file, object.getClass().getSimpleName().toLowerCase(), properties);
    }

    public T getObject() {
        return this.object;
    }
}

