/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.storage;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    static final String LIST = "list";
    static final String ITEM = "item";
    private Map<String, Property> properties = new LinkedHashMap<String, Property>();

    public int getSize() {
        Iterator<Map.Entry<String, Property>> i = this.properties.entrySet().iterator();
        while (i.hasNext()) {
            Property p = i.next().getValue();
            if (p instanceof SimpleProperty) {
                SimpleProperty sp = (SimpleProperty)p;
                if (sp.value != null) continue;
                i.remove();
                continue;
            }
            ListProperty lp = (ListProperty)p;
            if (!lp.elements.isEmpty()) continue;
            i.remove();
        }
        return this.properties.size();
    }

    public String getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            return null;
        }
        return ((SimpleProperty)this.properties.get((Object)name)).value;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, new SimpleProperty(value));
    }

    public List<Properties> getList(String name) {
        if (!this.properties.containsKey(name)) {
            return new ArrayList<Properties>();
        }
        return ((ListProperty)this.properties.get((Object)name)).elements;
    }

    public List<Properties> addList(String name, String elementName) {
        ListProperty property = new ListProperty(elementName, new ArrayList<Properties>());
        this.properties.put(name, property);
        return property.elements;
    }

    void addList(String name, String elementName, List<Properties> elements) {
        ListProperty property = new ListProperty(elementName, elements);
        this.properties.put(name, property);
    }

    void write(String rootElement, Writer writer, int indent) throws IOException {
        if (this.getSize() > 0) {
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
            writer.write("<");
            writer.write(rootElement);
            writer.write(" type='item'");
            writer.write(">\n");
            for (String name : this.properties.keySet()) {
                Property property = this.properties.get(name);
                property.write(name, writer, indent + 2);
            }
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
            writer.write("</");
            writer.write(rootElement);
            writer.write(">\n");
        } else {
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
            writer.write("<");
            writer.write(rootElement);
            writer.write("/>\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListProperty
    extends Property {
        String elementName;
        List<Properties> elements;

        public ListProperty(String elementName, List<Properties> elements) {
            this.elementName = elementName;
            this.elements = elements;
        }

        @Override
        void write(String name, Writer writer, int indent) throws IOException {
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
            writer.write("<");
            writer.write(name);
            writer.write(" type='list'");
            writer.write(">\n");
            for (Properties properties : this.elements) {
                properties.write(this.elementName, writer, indent + 2);
            }
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
            writer.write("</");
            writer.write(name);
            writer.write(">\n");
        }
    }

    private static class SimpleProperty
    extends Property {
        String value;

        public SimpleProperty(String value) {
            this.value = value;
        }

        void write(String name, Writer writer, int indent) throws IOException {
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
            writer.write("<");
            writer.write(name);
            writer.write(">");
            writer.write(this.getEncodedValue());
            writer.write("</");
            writer.write(name);
            writer.write(">\n");
        }

        String getEncodedValue() {
            return this.value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
    }

    private static abstract class Property {
        private Property() {
        }

        abstract void write(String var1, Writer var2, int var3) throws IOException;
    }
}

