/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.storage;

import java.util.HashMap;
import java.util.Map;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;
import ua.com.softway.tracker.storage.Xml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDirectory<T>
implements ObjectUpdater<T> {
    private final Serializer<T> serializer;
    private final Folder folder;
    private final Map<String, T> objects = new HashMap<String, T>();

    public ObjectDirectory(Serializer<T> serializer, Folder folder) {
        this.serializer = serializer;
        this.folder = folder;
        this.load();
    }

    private void load() {
        this.objects.clear();
        for (File file : this.folder.getFiles()) {
            String key = file.getName();
            Properties properties = Xml.load(file);
            T object = this.serializer.load(this, properties, key);
            this.objects.put(key, object);
        }
    }

    void save() {
        this.clearDirectory();
        for (String key : this.objects.keySet()) {
            T object = this.objects.get(key);
            this.saveObject(key, object);
        }
    }

    private void clearDirectory() {
        for (File file : this.folder.getFiles()) {
            file.delete();
        }
    }

    private void saveObject(String key, T object) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (key.trim().equals("")) {
            throw new IllegalArgumentException("key is blank");
        }
        Properties properties = new Properties();
        this.serializer.save(properties, object);
        Xml.save(this.folder.getFile(key), object.getClass().getSimpleName().toLowerCase(), properties);
    }

    @Override
    public void saveOrUpdate(T object) {
        String key = this.serializer.getKey(object);
        this.saveObject(key, object);
        this.objects.put(key, object);
    }

    public Map<String, T> getObjects() {
        return this.objects;
    }

    public void delete(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key==null");
        }
        if (!this.objects.containsKey(key)) {
            throw new IllegalArgumentException("can't find object with key '" + key + "'");
        }
        this.folder.getFile(key).delete();
        this.objects.remove(key);
    }
}

