/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.startup;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lime.Cookies;
import lime.Filter;
import lime.FilterChain;
import lime.Lime;
import lime.Namespace;
import lime.NamespaceTemplate;
import lime.download.DownloadHandler;
import lime.handler.RedirectHandler;
import lime.outcome.Redirect;
import org.apache.log4j.Logger;
import ua.com.softway.tracker.Migrator;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.ComponentAction;
import ua.com.softway.tracker.action.ErrorAction;
import ua.com.softway.tracker.action.LoginAction;
import ua.com.softway.tracker.action.MessageOutcomeHandler;
import ua.com.softway.tracker.action.PasswordReminderAction;
import ua.com.softway.tracker.action.PreferencesAction;
import ua.com.softway.tracker.action.ProfileAction;
import ua.com.softway.tracker.action.UrlRedirectHandler;
import ua.com.softway.tracker.action.home.HomeAction;
import ua.com.softway.tracker.action.issue.AssignIssueAction;
import ua.com.softway.tracker.action.issue.AttachmentAction;
import ua.com.softway.tracker.action.issue.BrowseIssuesAction;
import ua.com.softway.tracker.action.issue.CloseIssueAction;
import ua.com.softway.tracker.action.issue.DeleteIssueAction;
import ua.com.softway.tracker.action.issue.IssueAction;
import ua.com.softway.tracker.action.issue.IssueFilterForm;
import ua.com.softway.tracker.action.issue.IssuePaging;
import ua.com.softway.tracker.action.issue.ReopenIssueAction;
import ua.com.softway.tracker.action.issue.ResolveIssueAction;
import ua.com.softway.tracker.action.issue.ViewIssueAction;
import ua.com.softway.tracker.action.manage.EditVersionAction;
import ua.com.softway.tracker.action.manage.GroupAction;
import ua.com.softway.tracker.action.manage.GroupUsersAction;
import ua.com.softway.tracker.action.manage.MigrateAction;
import ua.com.softway.tracker.action.manage.ProjectAction;
import ua.com.softway.tracker.action.manage.SystemSettingsAction;
import ua.com.softway.tracker.action.manage.UserAction;
import ua.com.softway.tracker.action.manage.VersionAction;
import ua.com.softway.tracker.configuration.ConfigurationAction;
import ua.com.softway.tracker.configuration.Configurator;
import ua.com.softway.tracker.configuration.TrackerConfiguration;
import ua.com.softway.tracker.events.action.TimelineAction;
import ua.com.softway.tracker.fs.nativefs.NativeFileSystem;
import ua.com.softway.tracker.i18n.AddBundleListener;
import ua.com.softway.tracker.i18n.ResourceScanner;
import ua.com.softway.tracker.issuebrowser.action.IssueBrowserConfigurationAction;
import ua.com.softway.tracker.license.InvalidLicenseAction;
import ua.com.softway.tracker.license.UpdateLicenseAction;
import ua.com.softway.tracker.permissions.action.ProjectPermissionsAction;
import ua.com.softway.tracker.portlet.action.HomepageSettingsAction;
import ua.com.softway.tracker.startup.AdministrationFilter;
import ua.com.softway.tracker.startup.SessionObject;
import ua.com.softway.tracker.startup.UserSession;
import ua.com.softway.tracker.velocity.VelocityHandler;
import ua.com.softway.tracker.wiki.action.PageHistory;
import ua.com.softway.tracker.wiki.action.ViewPageAction;
import ua.com.softway.tracker.wiki.action.WikiFolderAction;
import ua.com.softway.tracker.wiki.action.WikiHomeAction;
import ua.com.softway.tracker.wiki.action.page.ManagePageAction;
import ua.com.softway.tracker.worklog.TimeReportAction;

public class TrackerLimeServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger("ua.com.softway.tracker.startup");
    private Migrator migrator;

    public void init() throws ServletException {
        log.info("Loading Clarity ... ");
        this.initI18n();
        this.migrator = new Migrator();
        log.info("Done");
    }

    private void initI18n() {
        ResourceScanner scanner = new ResourceScanner(new AddBundleListener());
        if (scanner.findInFileSystem(new NativeFileSystem().getFolder("./src/main/java/ua"))) {
            scanner.findInFileSystem(new NativeFileSystem().getFolder("./src/main/web"));
            log.info("Resources: using IDE mode");
            return;
        }
        if (scanner.findInClasspath()) {
            log.info("Resources: using standalone mode");
            return;
        }
        if (scanner.findInExplodedWar(this.getServletContext())) {
            log.info("Resources: using exploded WAR mode");
            return;
        }
        if (scanner.findInTomcatWar(this.getServletContext())) {
            log.info("Resources: using Tomcat packed WAR mode");
            return;
        }
        throw new RuntimeException("Can't find i18n resources");
    }

    private void initSessionIfRequired(HttpServletRequest request, HttpServletResponse response) {
        IssueFilterForm issueFilterForm;
        Cookies cookies = new Cookies(request, response);
        HttpSession httpSession = request.getSession();
        if (SessionObject.get(request, UserSession.class) == null) {
            UserSession userSession = new UserSession();
            httpSession.setAttribute(UserSession.class.getName(), userSession);
        }
        if (SessionObject.get(request, IssueFilterForm.class) == null && SessionObject.get(request, UserSession.class).isLogged()) {
            issueFilterForm = new IssueFilterForm(Tracker.instance());
            if (cookies.getCookie("currentProject") != null) {
                issueFilterForm.project = cookies.getCookie("currentProject").getValue();
            }
            httpSession.setAttribute(IssueFilterForm.class.getName(), issueFilterForm);
            IssuePaging issuePaging = new IssuePaging(User.currentUser().getPreferences().getIssuePageSize(), issueFilterForm);
            httpSession.setAttribute(IssuePaging.class.getName(), issuePaging);
        }
        if (SessionObject.get(request, PageHistory.class) == null) {
            httpSession.setAttribute(PageHistory.class.getName(), new PageHistory());
        }
        if ((issueFilterForm = SessionObject.get(request, IssueFilterForm.class)) != null && issueFilterForm.getCurrentProject() != null) {
            Cookie cookie = new Cookie("currentProject", issueFilterForm.getCurrentProject().getKey());
            cookie.setMaxAge(31536000);
            cookie.setPath(request.getContextPath() + "/");
            cookies.addCookie(cookie);
        }
    }

    private Lime lime(HttpServletRequest request) {
        Lime lime = Lime.instance();
        NamespaceTemplate namespaceTemplate = lime.getNamespaceTemplate();
        namespaceTemplate.addOutcomeHandler(new RedirectHandler());
        namespaceTemplate.addOutcomeHandler(new UrlRedirectHandler());
        namespaceTemplate.addOutcomeHandler(new DownloadHandler());
        namespaceTemplate.addOutcomeHandler(new VelocityHandler());
        namespaceTemplate.addOutcomeHandler(new MessageOutcomeHandler());
        UserSession userSession = SessionObject.get(request, UserSession.class);
        Namespace trackerUser = lime.addNamespace("/tracker");
        trackerUser.addAction(new ErrorAction());
        trackerUser.addAction(new LoginAction(userSession));
        TrackerConfiguration configuration = Configurator.getConfiguration();
        Namespace trackerLicense = lime.addNamespace("/license");
        trackerLicense.addAction(new InvalidLicenseAction());
        if (configuration.isConfigured()) {
            Tracker tracker = Tracker.instance();
            trackerUser.addAction(new PasswordReminderAction(tracker));
            trackerUser.addFilter(new NoProjectsFilter());
            Namespace trackerAdmin = lime.addNamespace("/tracker/admin");
            trackerAdmin.addFilter(new AdministrationFilter(tracker.getAdministratorsGroup()));
            Namespace wiki = lime.addNamespace("/wiki");
            PageHistory pageHistory = SessionObject.get(request, PageHistory.class);
            wiki.addAction(new WikiHomeAction(pageHistory));
            wiki.addAction(new ManagePageAction());
            wiki.addAction(new ViewPageAction(pageHistory));
            if (userSession.isLogged()) {
                IssueFilterForm filterForm = SessionObject.get(request, IssueFilterForm.class);
                IssuePaging issuePaging = SessionObject.get(request, IssuePaging.class);
                trackerUser.addAction(new HomeAction(tracker, filterForm));
                trackerUser.addAction(new IssueAction(tracker, filterForm));
                trackerUser.addAction(new ProfileAction());
                trackerUser.addAction(new BrowseIssuesAction(filterForm, issuePaging));
                trackerUser.addAction(new ViewIssueAction(tracker));
                trackerUser.addAction(new ResolveIssueAction(tracker));
                trackerUser.addAction(new CloseIssueAction(tracker));
                trackerUser.addAction(new ReopenIssueAction(tracker));
                trackerUser.addAction(new DeleteIssueAction(tracker));
                trackerUser.addAction(new AssignIssueAction(tracker));
                trackerUser.addAction(new AttachmentAction(tracker));
                trackerUser.addAction(new PreferencesAction());
                trackerUser.addAction(new VersionAction(tracker));
                trackerUser.addAction(new ComponentAction(tracker));
                trackerUser.addAction(new IssueBrowserConfigurationAction());
                trackerUser.addAction(new EditVersionAction(tracker));
                trackerUser.addAction(new TimeReportAction(tracker));
                trackerUser.addAction(new HomepageSettingsAction());
                trackerAdmin.addAction(new GroupUsersAction(tracker));
                trackerAdmin.addAction(new SystemSettingsAction(tracker));
                trackerAdmin.addAction(new ProjectPermissionsAction(tracker));
                trackerAdmin.addAction(new ProjectAction(tracker));
                trackerAdmin.addAction(new UserAction(tracker));
                trackerAdmin.addAction(new WikiFolderAction());
                trackerAdmin.addAction(new MigrateAction(tracker, this.migrator));
                trackerAdmin.addAction(new GroupAction(tracker));
                trackerAdmin.addAction(new UpdateLicenseAction());
                if (!tracker.getVisibleProjects().isEmpty()) {
                    trackerUser.addAction(new TimelineAction(tracker.getEventRecorder(), filterForm));
                }
            }
        } else {
            Namespace trackerConfiguration = lime.addNamespace("/configuration");
            trackerConfiguration.addAction(new ConfigurationAction());
        }
        return lime;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initSessionIfRequired(request, response);
        this.lime(request).process(request, response);
    }

    private static class NoProjectsFilter
    implements Filter {
        private NoProjectsFilter() {
        }

        public void filter(Object action, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (Tracker.instance().getVisibleProjects().isEmpty() && !(action instanceof LoginAction) && !(action instanceof PasswordReminderAction) && !(action instanceof ErrorAction)) {
                response.sendRedirect(new Redirect(ErrorAction.class, "noProjects").getPath());
                return;
            }
            chain.filter(action, request, response);
        }
    }
}

