/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.startup;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lime.Lime;
import lime.outcome.Redirect;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.ErrorAction;
import ua.com.softway.tracker.action.LoginAction;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.PasswordReminderAction;
import ua.com.softway.tracker.configuration.ConfigurationAction;
import ua.com.softway.tracker.configuration.Configurator;
import ua.com.softway.tracker.configuration.TrackerConfiguration;
import ua.com.softway.tracker.events.MailerDeamon;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.license.InvalidLicenseAction;
import ua.com.softway.tracker.startup.RemoteIpRestriction;
import ua.com.softway.tracker.startup.SessionObject;
import ua.com.softway.tracker.startup.UserSession;

public class RequestInitializationFilter
implements Filter {
    private RemoteIpRestriction remoteIpRestriction = new RemoteIpRestriction("./RemoteIpRestriction");
    private FilterConfig config;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String servletPath = request.getServletPath();
        if (servletPath.startsWith("/img") || servletPath.startsWith("/js") || servletPath.startsWith("/css")) {
            this.config.getServletContext().getNamedDispatcher("default").forward(request, response);
            return;
        }
        request.setCharacterEncoding("UTF-8");
        Lime.init(request.getContextPath());
        MailerDeamon.start(request.getContextPath());
        if (Configurator.getConfiguration() == null) {
            Configurator.initConfiguration(request);
        }
        if (!this.remoteIpRestriction.canAccessFromIp(request.getRemoteHost())) {
            System.out.println("denied from " + request.getRemoteHost() + " " + request.getServletPath());
            request.getRequestDispatcher("/oua-fake.html").forward(request, response);
            return;
        }
        TrackerConfiguration configuration = Configurator.getConfiguration();
        if (!configuration.isConfigured() && !this.runningAction(request, ConfigurationAction.class)) {
            response.sendRedirect(Pages.configuration().getPath());
            return;
        }
        if (!(configuration.getLicenseKey() != null && !configuration.getLicenseKey().isExpired() || this.runningAction(request, InvalidLicenseAction.class) || this.runningAction(request, ConfigurationAction.class))) {
            response.sendRedirect(Pages.invalidLicense().getPath());
            return;
        }
        if ("/".equals(request.getServletPath())) {
            response.sendRedirect(new Redirect(LoginAction.class, "test").getPath());
            return;
        }
        UserSession userSession = SessionObject.get(request, UserSession.class);
        if (userSession != null) {
            User.setCurrentUser(userSession.getUser());
        }
        if (!(User.currentUser() != null || this.runningAction(request, LoginAction.class) || request.getServletPath().startsWith("/exception") || this.runningAction(request, PasswordReminderAction.class) || this.runningAction(request, ErrorAction.class) || this.runningAction(request, InvalidLicenseAction.class) || this.runningAction(request, ConfigurationAction.class))) {
            response.sendRedirect(new Redirect(LoginAction.class, "forbidden", "url", this.getSavedUrl(request)).getPath());
            return;
        }
        Resources.setLocale("en");
        if (User.currentUser() != null) {
            Resources.setLocale(User.currentUser().getPreferences().getLocale());
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            User.setCurrentUser(null);
            Resources.setLocale(null);
        }
    }

    private String getSavedUrl(HttpServletRequest request) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            buffer.append("?");
            buffer.append(request.getQueryString());
        }
        return buffer.toString();
    }

    private boolean runningAction(HttpServletRequest request, Class actionClass) {
        Redirect redirect = new Redirect(actionClass, "hello");
        String path = redirect.getPath();
        path = path.substring(0, path.lastIndexOf("hello") - 1);
        String requestPath = request.getContextPath() + request.getServletPath();
        return requestPath.startsWith(path);
    }

    public void destroy() {
    }
}

