/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIpRestriction {
    private Set<String> allowedIps = new HashSet<String>();
    private boolean allowAny = false;

    public RemoteIpRestriction(String restrictionFile) {
        File remoteIpList = new File(restrictionFile);
        try {
            String ip;
            LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(new FileInputStream(remoteIpList)));
            while ((ip = lineReader.readLine()) != null) {
                this.allowedIps.add(ip.trim());
            }
            this.allowedIps.remove("");
            lineReader.close();
        }
        catch (FileNotFoundException e) {
            this.allowAny = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canAccessFromIp(String ip) {
        if (this.allowAny) {
            return true;
        }
        return this.allowedIps.contains(ip);
    }

    public Set<String> allowedIps() {
        return this.allowedIps;
    }
}

