/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.startup;

import java.io.File;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ErrorPageHandler;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Default;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.Resource;
import ua.com.softway.tracker.startup.ExceptionServlet;
import ua.com.softway.tracker.startup.RequestInitializationFilter;
import ua.com.softway.tracker.startup.TrackerLimeServlet;
import ua.com.softway.tracker.startup.TrackerSystemConfiguration;

public class Main {
    public static void main(String[] args) throws Exception {
        TrackerSystemConfiguration configuration = new TrackerSystemConfiguration();
        configuration.load(new File("./clarity.conf"));
        Main.configureLogger();
        Logger.getLogger("ua.com.softway.tracker.startup").info("Starting web-server on port " + configuration.port);
        Server server = Main.createTrackerWebServer(configuration.port);
        server.join();
    }

    public static Server createTrackerWebServer(int port) throws Exception {
        System.setProperty("org.mortbay.jetty.servlet.SessionCookie", "trackersessionid");
        Server httpServer = new Server();
        SocketListener socketListener = new SocketListener();
        socketListener.setPort(port);
        httpServer.addListener(socketListener);
        WebApplicationContext context = new WebApplicationContext();
        context.setContextPath("/");
        context.setDefaultsDescriptor(null);
        URL url = Main.class.getClassLoader().getResource("login.vm");
        String urlString = url.toString();
        url = new URL(urlString.substring(0, urlString.length() - "login.vm".length()));
        Resource resource = Resource.newResource(url);
        context.setBaseResource(resource);
        context.setErrorPage("500", "/exception/");
        context.setErrorPage("404", "/tracker/ErrorAction.notFound");
        context.setErrorPage("403", "/tracker/ErrorAction.forbidden");
        WebApplicationHandler webapp = new WebApplicationHandler();
        webapp.setAutoInitializeServlets(true);
        context.addHandler(webapp);
        webapp.addServlet("default", "/default_servlet", Default.class.getName());
        ServletHolder limeServlet = webapp.addServlet("LimeServlet", "/", TrackerLimeServlet.class.getName());
        limeServlet.setInitOrder(1);
        webapp.addServlet("ExceptionServlet", "/exception/", ExceptionServlet.class.getName());
        webapp.defineFilter("RequestInitializationFilter", RequestInitializationFilter.class.getName());
        webapp.addFilterServletMapping("LimeServlet", "RequestInitializationFilter", 0);
        webapp.addFilterServletMapping("LimeServlet", "RequestInitializationFilter", 8);
        HashSessionManager sessionManager = new HashSessionManager();
        webapp.setSessionManager(sessionManager);
        webapp.getSessionManager().setMaxInactiveInterval(32400);
        context.addHandler(new ResourceHandler());
        context.addHandler(new NotFoundHandler());
        context.addHandler(new ErrorPageHandler());
        httpServer.addContext(context);
        httpServer.start();
        return httpServer;
    }

    private static void configureLogger() {
        PatternLayout layout = new PatternLayout("%d [%t] %-5p %c %x - %m%n");
        ConsoleAppender appender = new ConsoleAppender(layout);
        BasicConfigurator.configure(appender);
        Logger.getRootLogger().setLevel(Level.WARN);
        Logger.getLogger("ua.com.softway").setLevel(Level.INFO);
    }
}

