/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.startup;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.SAXException;
import ua.com.softway.tracker.util.FieldAccessor;

public class ExceptionServlet
extends HttpServlet {
    public static final String EXCEPTION = "javax.servlet.error.exception";

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Throwable t = (Throwable)request.getAttribute(EXCEPTION);
        if (t == null) {
            response.setStatus(500);
            response.setContentType("text/html; charset=utf-8");
            PrintWriter out = response.getWriter();
            out.println("System error. Exception not available!");
            out.close();
        } else {
            response.setStatus(500);
            response.setContentType("text/html; charset=utf-8");
            PrintWriter out = response.getWriter();
            out.println("<html><head><style>");
            out.println(".message { color: red; }");
            out.println(".location { color: red; font-style: italic; }");
            out.println("</style>");
            out.println("<script><!--");
            out.println("function turn(id) {");
            out.println(" var div = document.getElementById(id);");
            out.println(" t = div.style.visibility == 'hidden';");
            out.println(" div.style.visibility = t? 'visible' : 'hidden'");
            out.println(" div.style.position = t? '' : 'absolute'");
            out.println("}");
            out.println("//-->");
            out.println("</script></head><body>");
            out.println("<h1>Exceptions happened during request processing</h1><hr/>");
            int count = 0;
            out.println("<h2>Exception <i>" + t.getMessage() + "</i></h2>");
            ExceptionServlet.dumpStackTrace(t, out, count * 100 + 0);
            out.println("</body></html>");
            out.close();
        }
    }

    private static void dumpStackTrace(Throwable e, PrintWriter out, int id) {
        StackTraceElement[] trace;
        out.println("<span class='message' onclick='turn(\"n" + id + "\")'>");
        out.println(e.getClass().getName() + ": ");
        out.println(e.toString());
        out.println("</span>");
        out.println("<div id='n" + id + "'>");
        out.println("<pre>");
        for (StackTraceElement el : trace = e.getStackTrace()) {
            out.println("   at " + el.toString());
        }
        out.println("</pre></div>");
        Throwable cause = ExceptionServlet.unwrap(e);
        if (cause != null) {
            out.print("<br><br>Caused by: ");
            ExceptionServlet.dumpStackTrace(cause, out, id + 1);
        }
    }

    private static Throwable unwrap(Throwable e) {
        Throwable cause = null;
        if (e instanceof SAXException) {
            SAXException m = (SAXException)e;
            cause = m.getException();
        }
        if (cause == null) {
            cause = e.getCause();
        }
        if (cause == null) {
            try {
                cause = (Throwable)FieldAccessor.readAccessibleField(e, "exception");
            }
            catch (SecurityException e1) {
            }
            catch (IllegalArgumentException e1) {
            }
            catch (NoSuchFieldException e1) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return cause;
    }
}

